package com.bitmart.api.request.contract.prv;

import com.bitmart.api.annotations.ParamKey;
import com.bitmart.api.request.Auth;
import com.bitmart.api.request.CloudRequest;
import com.bitmart.api.request.Method;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import lombok.experimental.Accessors;

@EqualsAndHashCode(callSuper = true)
@Data
@ToString
@Accessors(chain = true)
public class GetPositionRequest extends CloudRequest {

    /**
     * Symbol of the contract(like BTCUSDT)
     */
    @ParamKey("symbol")
    private String symbol;

    /**
     * Trading account
     * -futures
     * -copy_trading
     */
    @ParamKey("account")
    private String account;

    /**
     * Applicable for checking the position details a specified contract
     */
    public GetPositionRequest() {
        super("/contract/private/position", Method.GET, Auth.KEYED);
    }
}
