/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.DotenvParser;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DotenvBuilder {
    private String filename = ".env";
    private String directoryPath = "./";
    private boolean systemProperties = false;
    private boolean throwIfMissing = true;
    private boolean throwIfMalformed = true;

    public DotenvBuilder directory(String path) {
        this.directoryPath = path;
        return this;
    }

    public DotenvBuilder filename(String name) {
        this.filename = name;
        return this;
    }

    public DotenvBuilder ignoreIfMissing() {
        this.throwIfMissing = false;
        return this;
    }

    public DotenvBuilder ignoreIfMalformed() {
        this.throwIfMalformed = false;
        return this;
    }

    public DotenvBuilder systemProperties() {
        this.systemProperties = true;
        return this;
    }

    public Dotenv load() throws DotenvException {
        DotenvParser reader = new DotenvParser(new DotenvReader(this.directoryPath, this.filename), this.throwIfMissing, this.throwIfMalformed);
        List<DotenvEntry> env = reader.parse();
        if (this.systemProperties) {
            env.forEach(it -> System.setProperty(it.getKey(), it.getValue()));
        }
        return new DotenvImpl(env);
    }

    static class DotenvImpl
    implements Dotenv {
        private final Map<String, String> envVars;
        private final Set<DotenvEntry> set;
        private final Set<DotenvEntry> setInFile;
        private final Map<String, String> envVarsInFile;

        public DotenvImpl(List<DotenvEntry> envVars) {
            this.envVarsInFile = envVars.stream().collect(Collectors.toMap(DotenvEntry::getKey, DotenvEntry::getValue));
            this.envVars = new HashMap<String, String>(this.envVarsInFile);
            System.getenv().forEach(this.envVars::put);
            this.set = this.envVars.entrySet().stream().map(it -> new DotenvEntry((String)it.getKey(), (String)it.getValue())).collect(Collectors.toUnmodifiableSet());
            this.setInFile = this.envVarsInFile.entrySet().stream().map(it -> new DotenvEntry((String)it.getKey(), (String)it.getValue())).collect(Collectors.toUnmodifiableSet());
        }

        @Override
        public Set<DotenvEntry> entries() {
            return this.set;
        }

        @Override
        public Set<DotenvEntry> entries(DotenvEntry.Filter filter) {
            if (filter != null) {
                return this.setInFile;
            }
            return this.entries();
        }

        @Override
        public String get(String key) {
            String value = System.getenv(key);
            return value != null ? value : this.envVars.get(key);
        }

        @Override
        public String get(String key, String defaultValue) {
            String value = this.get(key);
            return value != null ? value : defaultValue;
        }
    }
}

