/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv.internal;

import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DotenvParser {
    private static final Pattern WHITE_SPACE_REGEX = Pattern.compile("^\\s*$");
    private static final Pattern DOTENV_ENTRY_REGEX = Pattern.compile("^\\s*([\\w.\\-]+)\\s*(=)\\s*(['][^']*[']|[\"][^\"]*[\"]|[^#]*)?\\s*(#.*)?$");
    private final DotenvReader reader;
    private final boolean throwIfMissing;
    private final boolean throwIfMalformed;
    private static final Predicate<String> isWhiteSpace = s -> DotenvParser.matches(WHITE_SPACE_REGEX, s);
    private static final Predicate<String> isComment = s -> s.startsWith("#") || s.startsWith("////");
    private static final Predicate<String> isQuoted = s -> s.length() > 1 && s.startsWith("\"") && s.endsWith("\"");
    private final Function<String, DotenvEntry> parseLine = s -> DotenvParser.matchEntry(DOTENV_ENTRY_REGEX, s);

    public DotenvParser(DotenvReader reader, boolean throwIfMissing, boolean throwIfMalformed) {
        this.reader = reader;
        this.throwIfMissing = throwIfMissing;
        this.throwIfMalformed = throwIfMalformed;
    }

    public List<DotenvEntry> parse() throws DotenvException {
        List<String> lines = this.lines();
        ArrayList<DotenvEntry> entries = new ArrayList<DotenvEntry>(lines.size());
        for (String line : lines) {
            this.addNewEntry(entries, line.trim());
        }
        return entries;
    }

    private void addNewEntry(List<DotenvEntry> entries, String line) {
        if (isWhiteSpace.test(line) || isComment.test(line) || DotenvParser.isBlank(line)) {
            return;
        }
        DotenvEntry entry = this.parseLine.apply(line);
        if (entry == null) {
            if (this.throwIfMalformed) {
                throw new DotenvException("Malformed entry " + line);
            }
            return;
        }
        if (!QuotedStringValidator.isValid(entry.getValue())) {
            if (this.throwIfMalformed) {
                throw new DotenvException("Malformed entry, unmatched quotes " + line);
            }
            return;
        }
        String key = entry.getKey();
        String value = QuotedStringValidator.stripQuotes(entry.getValue());
        entries.add(new DotenvEntry(key, value));
    }

    private List<String> lines() throws DotenvException {
        try {
            return this.reader.read();
        }
        catch (DotenvException e) {
            if (this.throwIfMissing) {
                throw e;
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new DotenvException(e);
        }
    }

    private static boolean matches(Pattern regex, String text) {
        return regex.matcher(text).matches();
    }

    private static DotenvEntry matchEntry(Pattern regex, String text) {
        Matcher matcher = regex.matcher(text);
        if (!matcher.matches() || matcher.groupCount() < 3) {
            return null;
        }
        return new DotenvEntry(matcher.group(1), matcher.group(3));
    }

    private static boolean isBlank(String s) {
        return s == null || s.trim().isEmpty();
    }

    private static class QuotedStringValidator {
        private QuotedStringValidator() {
        }

        private static boolean isValid(String input) {
            String s = input.trim();
            if (!s.startsWith("\"") && !s.endsWith("\"")) {
                return true;
            }
            if (input.length() == 1 || !s.startsWith("\"") || !s.endsWith("\"")) {
                return false;
            }
            String content = s.substring(1, s.length() - 1);
            Pattern quotePattern = Pattern.compile("\"");
            Matcher matcher = quotePattern.matcher(content);
            while (matcher.find()) {
                int quoteIndex = matcher.start();
                if (quoteIndex != 0 && content.charAt(quoteIndex - 1) == '\\') continue;
                return false;
            }
            return true;
        }

        private static String stripQuotes(String input) {
            String tr = input.trim();
            return isQuoted.test(tr) ? tr.substring(1, input.length() - 1) : tr;
        }
    }
}

