package io.github.cdimascio.dotenv

import java.io.InputStream

fun dotenv(block: Configuration.() -> Unit = {}): Dotenv {
    val config = Configuration()
    block(config)
    val dotenv = Dotenv.configure().directory(config.directory)
    if (config.stream != null) dotenv.stream(config.stream!!)
    if (config.ignoreIfMalformed) dotenv.ignoreIfMalformed()
    if (config.ignoreIfMissing) dotenv.ignoreIfMissing()
    return dotenv.load()
}

class Configuration {
    var directory: String = ""
    var stream: InputStream? = null
    var ignoreIfMalformed = false
    var ignoreIfMissing = false
}