/*
 * Decompiled with CFR 0.152.
 */
package io.github.cloudstars.lowcode.api.executor;

import io.github.cloudstars.lowcode.api.executor.ApiExecutor;
import io.github.cloudstars.lowcode.api.executor.ApiResult;
import io.github.cloudstars.lowcode.api.executor.filter.ApiExecuteFilterChain;
import io.github.cloudstars.lowcode.api.executor.invoke.ApiFileUploadRequest;
import io.github.cloudstars.lowcode.api.executor.invoke.ApiInvoker;
import io.github.cloudstars.lowcode.api.executor.invoke.ApiRequest;
import io.github.cloudstars.lowcode.api.executor.invoke.ApiResponse;
import io.github.cloudstars.lowcode.commons.api.config.ApiConfig;
import io.github.cloudstars.lowcode.commons.api.config.request.ApiRequestBodyConfig;
import io.github.cloudstars.lowcode.commons.api.config.request.ApiRequestConfig;
import io.github.cloudstars.lowcode.commons.api.config.request.ApiRequestQueryParamConfig;
import io.github.cloudstars.lowcode.commons.api.config.request.HttpMethod;
import io.github.cloudstars.lowcode.commons.api.config.request.RequestContentTypeEnum;
import io.github.cloudstars.lowcode.commons.lang.exception.SystemException;
import io.github.cloudstars.lowcode.commons.lang.util.ObjectUtils;
import io.github.cloudstars.lowcode.value.loader.ValueTypeFactory;
import io.github.cloudstars.lowcode.value.loader.XValueType;
import io.github.cloudstars.lowcode.value.type.XValueTypeConfig;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class ApiExecutorImpl
implements ApiExecutor {
    private ApiInvoker apiInvoker;
    private ApiExecuteFilterChain filterChain;

    public ApiExecutorImpl(ApiInvoker apiInvoker) {
        this.apiInvoker = apiInvoker;
    }

    public ApiExecutorImpl(ApiInvoker apiInvoker, ApiExecuteFilterChain filterChain) {
        this.apiInvoker = apiInvoker;
        this.filterChain = filterChain;
    }

    @Override
    public ApiResult execute(ApiConfig apiConfig) {
        return this.execute(apiConfig, null);
    }

    @Override
    public ApiResult execute(ApiConfig apiConfig, Object params) {
        ApiRequest apiRequest = this.makeRequest(apiConfig, params);
        if (this.filterChain != null) {
            this.filterChain.doFilter(apiRequest, null);
        }
        ApiResponse apiResponse = this.sendRequest(apiConfig, apiRequest);
        ApiResult apiResult = this.makeResult(apiConfig, apiResponse);
        if (this.filterChain != null) {
            this.filterChain.doFilter(apiRequest, apiResponse);
        }
        return apiResult;
    }

    private ApiRequest makeRequest(ApiConfig config, Object params) {
        ApiRequestConfig apiRequestConfig = config.getRequest();
        HttpMethod apiRequestMethod = apiRequestConfig.getMethod();
        ApiRequest apiRequest = null;
        if (apiRequestMethod == HttpMethod.GET) {
            apiRequest = this.makeGetRequest(config, params);
        } else if (apiRequestMethod == HttpMethod.POST) {
            apiRequest = this.makePostRequest(config, params);
        } else {
            throw new SystemException("\u4e0d\u652f\u6301\u7684HTTP\u65b9\u6cd5\uff1a" + apiRequestMethod);
        }
        return apiRequest;
    }

    private ApiRequest makeGetRequest(ApiConfig config, Object params) {
        ApiRequestConfig apiRequestConfig = config.getRequest();
        ApiRequest apiRequest = this.makeInitApiRequest(apiRequestConfig, params);
        return apiRequest;
    }

    private ApiRequest makePostRequest(ApiConfig config, Object params) {
        ApiRequestConfig apiRequestConfig = config.getRequest();
        ApiRequest apiRequest = this.makeInitApiRequest(apiRequestConfig, params);
        Object targetValue = params;
        RequestContentTypeEnum requestContentType = apiRequestConfig.getContentType();
        ApiRequestBodyConfig apiRequestBodyConfig = apiRequestConfig.getBody();
        XValueTypeConfig apiRequestValueTypeConfig = apiRequestBodyConfig.getValueType();
        if (apiRequestValueTypeConfig != null) {
            XValueType valueType = ValueTypeFactory.newInstance((XValueTypeConfig)apiRequestValueTypeConfig);
            targetValue = valueType.mergeDefaultValue(params);
        }
        if (requestContentType == RequestContentTypeEnum.APPLICATION_JSON) {
            apiRequest.setBody(targetValue);
        } else {
            apiRequest.setFormItems((Map)targetValue);
        }
        return apiRequest;
    }

    private ApiRequest makeInitApiRequest(ApiRequestConfig apiRequestConfig, Object params) {
        ApiRequest apiRequest = new ApiRequest();
        apiRequest.setUrl(apiRequestConfig.getServicePath());
        apiRequest.setMethod(apiRequestConfig.getMethod());
        List queryParamConfigs = apiRequestConfig.getQueryParamConfigs();
        if (!CollectionUtils.isEmpty((Collection)queryParamConfigs) && params != null) {
            HashMap<String, Object> queryParams = new HashMap<String, Object>();
            for (ApiRequestQueryParamConfig queryParamConfig : queryParamConfigs) {
                String paramName = queryParamConfig.getName();
                Object paramValue = ObjectUtils.getFieldValue((Object)params, (String)paramName);
                queryParams.put(paramName, paramValue);
            }
            apiRequest.setQueryParams(queryParams);
        }
        return apiRequest;
    }

    private ApiResponse sendRequest(ApiConfig apiConfig, ApiRequest apiRequest) {
        RequestContentTypeEnum apiRequestContentType;
        ApiRequestConfig apiRequestConfig = apiConfig.getRequest();
        ApiResponse apiResponse = null;
        HttpMethod method = apiRequestConfig.getMethod();
        apiResponse = method == HttpMethod.GET ? this.sendGetRequest(apiRequest) : ((apiRequestContentType = apiRequestConfig.getContentType()) == RequestContentTypeEnum.MULTIPART_FORM_DATA ? this.sendFileUploadRequest(apiRequest) : this.sendPostRequest(apiRequest));
        return apiResponse;
    }

    private ApiResponse sendGetRequest(ApiRequest request) {
        ApiResponse apiResponse = this.apiInvoker.get(request);
        return apiResponse;
    }

    private ApiResponse sendPostRequest(ApiRequest request) {
        ApiResponse apiResponse = this.apiInvoker.post(request);
        return apiResponse;
    }

    private ApiResponse sendFileUploadRequest(ApiRequest request) {
        ApiFileUploadRequest fileUploadRequest = new ApiFileUploadRequest();
        fileUploadRequest.setUrl(request.getUrl());
        fileUploadRequest.setHeaders(request.getHeaders());
        fileUploadRequest.setFormItems(request.getFormItems());
        ApiResponse apiResponse = this.apiInvoker.uploadFile(fileUploadRequest);
        return apiResponse;
    }

    private ApiResult makeResult(ApiConfig apiConfig, ApiResponse apiResponse) {
        ApiResult apiResult = new ApiResult();
        apiResult.success(apiResponse.getBody());
        return apiResult;
    }
}

