/*
 * Decompiled with CFR 0.152.
 */
package io.github.cloudstars.lowcode.api.executor.filter;

import io.github.cloudstars.lowcode.api.executor.filter.AbstractApiExecuteFilter;
import io.github.cloudstars.lowcode.api.executor.filter.ApiExecuteFilterChain;
import io.github.cloudstars.lowcode.api.executor.invoke.ApiRequest;
import io.github.cloudstars.lowcode.commons.lang.util.VariableUtils;
import java.util.Map;
import java.util.regex.Pattern;

public class PathVariableReplaceFilter
extends AbstractApiExecuteFilter {
    private static final Pattern VAR_PATTERN = Pattern.compile("\\{([\\w_]+)\\}");

    public PathVariableReplaceFilter(ApiExecuteFilterChain filterChain) {
        super(filterChain);
    }

    @Override
    protected void doBeforeRequest(ApiRequest apiRequest) {
        String url = apiRequest.getUrl();
        Map<String, Object> queryParams = apiRequest.getQueryParams();
        if (queryParams == null || queryParams.size() == 0) {
            return;
        }
        apiRequest.setUrl(VariableUtils.replacePlaceholder((String)url, queryParams));
    }
}

