/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.predicates.collections;

import java.util.Arrays;
import java.util.function.Predicate;

public interface ArrayPredicates {
    public <T> Predicate<T[]> hasLength(int var1);

    public <T> Predicate<T[]> hasLengthGreaterThan(int var1);

    public <T> Predicate<T[]> hasLengthLessThan(int var1);

    public <T> Predicate<T[]> hasLengthEqualOrGreaterThan(int var1);

    public <T> Predicate<T[]> hasLengthEqualOrLessThan(int var1);

    public <T> Predicate<T[]> equals(T[] var1);

    public <T> Predicate<T[]> contains(T var1);

    public <T> Predicate<T[]> containsAllOf(T ... var1);

    public <T> Predicate<T[]> containsAnyOf(T ... var1);

    public <T> Predicate<T[]> containsNoneOf(T ... var1);

    public <T> Predicate<T[]> isEmpty();

    public <T> Predicate<T[]> isNotEmpty();

    public static final class Default
    implements ArrayPredicates {
        @Override
        public <T> Predicate<T[]> hasLength(int length) {
            return outer -> ((Object[])outer).length == length;
        }

        @Override
        public <T> Predicate<T[]> hasLengthGreaterThan(int min) {
            return outer -> ((Object[])outer).length > min;
        }

        @Override
        public <T> Predicate<T[]> hasLengthLessThan(int max) {
            return outer -> ((Object[])outer).length < max;
        }

        @Override
        public <T> Predicate<T[]> hasLengthEqualOrGreaterThan(int min) {
            return outer -> ((Object[])outer).length >= min;
        }

        @Override
        public <T> Predicate<T[]> hasLengthEqualOrLessThan(int max) {
            return outer -> ((Object[])outer).length <= max;
        }

        @Override
        public <T> Predicate<T[]> equals(T[] inner) {
            return outer -> Arrays.equals(outer, inner);
        }

        @Override
        public <T> Predicate<T[]> contains(T element) {
            return outer -> Arrays.asList(outer).contains(element);
        }

        @Override
        public <T> Predicate<T[]> containsAllOf(T[] elements) {
            return outer -> Arrays.asList(outer).containsAll(Arrays.asList(elements));
        }

        @Override
        public <T> Predicate<T[]> containsAnyOf(T[] elements) {
            return outer -> Arrays.stream(outer).anyMatch(Arrays.asList(elements)::contains);
        }

        @Override
        public <T> Predicate<T[]> containsNoneOf(T[] elements) {
            return outer -> !this.containsAnyOf(elements).test((Object[])outer);
        }

        @Override
        public <T> Predicate<T[]> isEmpty() {
            return outer -> ((Object[])outer).length == 0;
        }

        @Override
        public <T> Predicate<T[]> isNotEmpty() {
            return outer -> this.isEmpty().negate().test((T[])outer);
        }
    }
}

