/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.predicates.collections;

import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Predicate;

public interface CollectionPredicates {
    public <T> Predicate<Collection<T>> hasSize(int var1);

    public <T> Predicate<Collection<T>> hasSizeGreaterThan(int var1);

    public <T> Predicate<Collection<T>> hasSizeLessThan(int var1);

    public <T> Predicate<Collection<T>> hasSizeEqualOrGreaterThan(int var1);

    public <T> Predicate<Collection<T>> hasSizeEqualOrLessThan(int var1);

    public <T> Predicate<Collection<T>> equals(Collection<T> var1);

    public <T> Predicate<Collection<T>> contains(T var1);

    public <T> Predicate<Collection<T>> containsAllOf(Collection<T> var1);

    public <T> Predicate<Collection<T>> containsAllOf(T ... var1);

    public <T> Predicate<Collection<T>> containsAnyOf(Collection<T> var1);

    public <T> Predicate<Collection<T>> containsAnyOf(T ... var1);

    public <T> Predicate<Collection<T>> containsNoneOf(Collection<T> var1);

    public <T> Predicate<Collection<T>> containsNoneOf(T ... var1);

    public <T> Predicate<Collection<T>> isEmpty();

    public <T> Predicate<Collection<T>> isNotEmpty();

    public <T> Predicate<Collection<T>> isNull();

    public <T> Predicate<Collection<T>> isNotNull();

    public static final class Default
    implements CollectionPredicates {
        @Override
        public <T> Predicate<Collection<T>> hasSize(int size) {
            return outer -> outer.size() == size;
        }

        @Override
        public <T> Predicate<Collection<T>> hasSizeGreaterThan(int min) {
            return outer -> outer.size() > min;
        }

        @Override
        public <T> Predicate<Collection<T>> hasSizeLessThan(int max) {
            return outer -> outer.size() < max;
        }

        @Override
        public <T> Predicate<Collection<T>> hasSizeEqualOrGreaterThan(int min) {
            return outer -> outer.size() >= min;
        }

        @Override
        public <T> Predicate<Collection<T>> hasSizeEqualOrLessThan(int max) {
            return outer -> outer.size() <= max;
        }

        @Override
        public <T> Predicate<Collection<T>> equals(Collection<T> inner) {
            return inner::equals;
        }

        @Override
        public <T> Predicate<Collection<T>> contains(T element) {
            return outer -> outer.contains(element);
        }

        @Override
        public <T> Predicate<Collection<T>> containsAllOf(Collection<T> elements) {
            return outer -> elements.stream().allMatch(outer::contains);
        }

        @Override
        public <T> Predicate<Collection<T>> containsAllOf(T[] elements) {
            return outer -> this.containsAllOf(Arrays.asList(elements)).test((Collection<Object>)outer);
        }

        @Override
        public <T> Predicate<Collection<T>> containsAnyOf(Collection<T> elements) {
            return outer -> elements.stream().anyMatch(outer::contains);
        }

        @Override
        public <T> Predicate<Collection<T>> containsAnyOf(T[] elements) {
            return outer -> this.containsAnyOf(Arrays.asList(elements)).test((Collection<Object>)outer);
        }

        @Override
        public <T> Predicate<Collection<T>> containsNoneOf(Collection<T> elements) {
            return outer -> elements.stream().noneMatch(outer::contains);
        }

        @Override
        public <T> Predicate<Collection<T>> containsNoneOf(T[] elements) {
            return outer -> this.containsNoneOf(Arrays.asList(elements)).test((Collection<Object>)outer);
        }

        @Override
        public <T> Predicate<Collection<T>> isEmpty() {
            return Collection::isEmpty;
        }

        @Override
        public <T> Predicate<Collection<T>> isNotEmpty() {
            return outer -> !outer.isEmpty();
        }

        @Override
        public <T> Predicate<Collection<T>> isNull() {
            return Objects::isNull;
        }

        @Override
        public <T> Predicate<Collection<T>> isNotNull() {
            return Objects::nonNull;
        }
    }
}

