/*
 * Decompiled with CFR 0.152.
 */
package io.github.codejanovic.java.predicates.primitives;

import io.github.codejanovic.java.predicates.helper.Throws;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Predicate;

public interface StringPredicates {
    public Predicate<String> equals(String var1);

    public Predicate<String> equalsIgnoreCase(String var1);

    public Predicate<String> startsWith(String var1);

    public Predicate<String> endsWith(String var1);

    public Predicate<String> startsWithIgnoreCase(String var1);

    public Predicate<String> endsWithIgnoreCase(String var1);

    public Predicate<String> hasLengthGreaterThan(int var1);

    public Predicate<String> hasLengthLessThan(int var1);

    public Predicate<String> hasLengthEqualOrGreaterThan(int var1);

    public Predicate<String> hasLengthEqualOrLessThan(int var1);

    public Predicate<String> hasLength(int var1);

    public Predicate<String> isBoolean();

    public Predicate<String> isInteger();

    public Predicate<String> isUUID();

    public Predicate<String> contains(String var1);

    public Predicate<String> containsIgnoreCase(String var1);

    public Predicate<String> isEmpty();

    public Predicate<String> isNotEmpty();

    public Predicate<String> isNull();

    public Predicate<String> isNotNull();

    public static final class Default
    implements StringPredicates {
        @Override
        public Predicate<String> equals(String inner) {
            return inner::equals;
        }

        @Override
        public Predicate<String> equalsIgnoreCase(String inner) {
            return inner::equalsIgnoreCase;
        }

        @Override
        public Predicate<String> startsWith(String inner) {
            return outer -> outer.startsWith(inner);
        }

        @Override
        public Predicate<String> endsWith(String inner) {
            return outer -> outer.endsWith(inner);
        }

        @Override
        public Predicate<String> startsWithIgnoreCase(String inner) {
            return outer -> outer.toLowerCase().startsWith(inner.toLowerCase());
        }

        @Override
        public Predicate<String> endsWithIgnoreCase(String inner) {
            return outer -> outer.toLowerCase().endsWith(inner.toLowerCase());
        }

        @Override
        public Predicate<String> hasLengthGreaterThan(int minLength) {
            return outer -> outer.length() > minLength;
        }

        @Override
        public Predicate<String> hasLengthLessThan(int maxLength) {
            return outer -> outer.length() < maxLength;
        }

        @Override
        public Predicate<String> hasLengthEqualOrGreaterThan(int minLength) {
            return outer -> outer.length() >= minLength;
        }

        @Override
        public Predicate<String> hasLengthEqualOrLessThan(int maxLength) {
            return outer -> outer.length() <= maxLength;
        }

        @Override
        public Predicate<String> hasLength(int length) {
            return outer -> outer.length() == length;
        }

        @Override
        public Predicate<String> isBoolean() {
            return outer -> this.equalsIgnoreCase("true").or(this.equalsIgnoreCase("false")).test((String)outer);
        }

        @Override
        public Predicate<String> isInteger() {
            return outer -> !Throws.exception(() -> Integer.parseInt(outer));
        }

        @Override
        public Predicate<String> isUUID() {
            return outer -> !Throws.exception(() -> UUID.fromString(outer));
        }

        @Override
        public Predicate<String> contains(String inner) {
            return outer -> outer.contains(inner);
        }

        @Override
        public Predicate<String> containsIgnoreCase(String inner) {
            return outer -> outer.toLowerCase().contains(inner.toLowerCase());
        }

        @Override
        public Predicate<String> isEmpty() {
            return outer -> outer.trim().isEmpty();
        }

        @Override
        public Predicate<String> isNotEmpty() {
            return outer -> this.isEmpty().negate().test((String)outer);
        }

        @Override
        public Predicate<String> isNull() {
            return Objects::isNull;
        }

        @Override
        public Predicate<String> isNotNull() {
            return Objects::nonNull;
        }
    }
}

