/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.datafusion;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JNILoader {
    private static final Logger logger = LoggerFactory.getLogger(JNILoader.class);
    private static final AtomicBoolean loaded = new AtomicBoolean(false);
    private static final String libraryName = "datafusion_jni";
    private static final String ERROR_MSG = String.format("Unsupported OS/arch (`%s' detected), cannot find `%s' or load `%s' from system libraries. Please try building from source the jar or providing %s in your system.", new Object[]{JNILoader.getOsName(), JNILoader.getResourceName(), "datafusion_jni", "datafusion_jni"});

    private JNILoader() {
    }

    private static OsName getOsName() {
        String os = System.getProperty("os.name").toLowerCase().replace(' ', '_');
        if (os.contains("win")) {
            return OsName.Windows;
        }
        if (os.startsWith("mac") || os.contains("os_x")) {
            return OsName.Osx;
        }
        return OsName.Linux;
    }

    private static String getResourceName() {
        return String.format("/jni_libs/lib%s.%s", libraryName, JNILoader.getExtension());
    }

    private static String getExtension() {
        OsName osName = JNILoader.getOsName();
        if (osName == OsName.Linux) {
            return "so";
        }
        if (osName == OsName.Osx) {
            return "dylib";
        }
        if (osName == OsName.Windows) {
            return "dll";
        }
        throw new IllegalStateException("Cannot determine the extension for " + (Object)((Object)osName));
    }

    static synchronized void load() {
        if (loaded.get()) {
            logger.debug("{} already loaded, returning", (Object)libraryName);
            return;
        }
        InputStream is = JNILoader.class.getResourceAsStream(JNILoader.getResourceName());
        if (is == null) {
            try {
                System.loadLibrary(libraryName);
                loaded.set(true);
                logger.debug("successfully loaded {} from library path", (Object)libraryName);
                return;
            }
            catch (UnsatisfiedLinkError e) {
                UnsatisfiedLinkError err = new UnsatisfiedLinkError(String.format("%s\n%s", e.getMessage(), ERROR_MSG));
                err.setStackTrace(e.getStackTrace());
                throw err;
            }
        }
        File tempFile = JNILoader.extractToTempFile(is);
        try {
            System.load(tempFile.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError le1) {
            try {
                System.loadLibrary(libraryName);
                logger.debug("successfully loaded {} from extracted lib file", (Object)libraryName);
                loaded.set(true);
            }
            catch (UnsatisfiedLinkError le2) {
                UnsatisfiedLinkError err = new UnsatisfiedLinkError(String.format("%s\n%s\n%s", le1.getMessage(), le2.getMessage(), ERROR_MSG));
                err.setStackTrace(le2.getStackTrace());
                throw err;
            }
        }
    }

    private static File extractToTempFile(InputStream is) {
        File tempFile;
        try {
            tempFile = File.createTempFile(libraryName, "." + JNILoader.getExtension(), null);
            tempFile.deleteOnExit();
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create temporary files", e);
        }
        try (InputStream in = is;
             FileOutputStream out = new FileOutputStream(tempFile);){
            int read;
            byte[] buf = new byte[4096];
            while ((read = in.read(buf)) != -1) {
                out.write(buf, 0, read);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to extract lib file and write to temp file", e);
        }
        return tempFile;
    }

    private static enum OsName {
        Windows,
        Osx,
        Linux;

    }
}

