/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.datafusion;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.arrow.datafusion.NativeProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractProxy
implements AutoCloseable,
NativeProxy {
    private static final Logger logger = LoggerFactory.getLogger(AbstractProxy.class);
    private final long pointer;
    private final AtomicBoolean closed;
    private final ConcurrentMap<Long, AbstractProxy> children;

    protected AbstractProxy(long pointer) {
        this.pointer = pointer;
        if (logger.isDebugEnabled()) {
            logger.debug("Obtaining {}@{}", (Object)this.getClass().getSimpleName(), (Object)Long.toHexString(pointer));
        }
        this.closed = new AtomicBoolean(false);
        this.children = new ConcurrentHashMap<Long, AbstractProxy>();
    }

    protected final void registerChild(AbstractProxy child) {
        AbstractProxy old = this.children.putIfAbsent(child.getPointer(), child);
        if (old != null) {
            logger.warn("duplicated registry for {}: {}", (Object)child.getPointer(), (Object)old);
        }
    }

    protected final boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public final long getPointer() {
        return this.pointer;
    }

    abstract void doClose(long var1) throws Exception;

    @Override
    public final void close() throws Exception {
        if (this.closed.compareAndSet(false, true)) {
            for (AbstractProxy child : this.children.values()) {
                if (child.isClosed()) continue;
                child.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Closing {}@{}", (Object)this.getClass().getSimpleName(), (Object)Long.toHexString(this.pointer));
            }
            this.doClose(this.pointer);
        } else {
            logger.warn("Failed to close {}, maybe already closed?", (Object)this.getPointer());
        }
    }
}

