/*
 * Decompiled with CFR 0.152.
 */
package org.apache.arrow.datafusion;

import java.nio.channels.SeekableByteChannel;
import java.util.concurrent.CompletableFuture;
import org.apache.arrow.datafusion.AbstractProxy;
import org.apache.arrow.datafusion.DataFrame;
import org.apache.arrow.datafusion.DataFrames;
import org.apache.arrow.datafusion.ExecutionContext;
import org.apache.arrow.datafusion.Runtime;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.ArrowReader;
import org.apache.arrow.vector.util.ByteArrayReadableSeekableByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultDataFrame
extends AbstractProxy
implements DataFrame {
    private static final Logger logger = LoggerFactory.getLogger(DefaultDataFrame.class);
    private final ExecutionContext context;

    DefaultDataFrame(ExecutionContext context, long pointer) {
        super(pointer);
        this.context = context;
    }

    @Override
    public CompletableFuture<ArrowReader> collect(BufferAllocator allocator) {
        CompletableFuture<ArrowReader> result = new CompletableFuture<ArrowReader>();
        Runtime runtime = this.context.getRuntime();
        long runtimePointer = runtime.getPointer();
        long dataframe = this.getPointer();
        DataFrames.collectDataframe(runtimePointer, dataframe, (errString, arr) -> {
            if (this.containsError((String)errString)) {
                result.completeExceptionally(new RuntimeException((String)errString));
            } else {
                logger.info("successfully completed with arr length={}", (Object)((byte[])arr).length);
                ByteArrayReadableSeekableByteChannel byteChannel = new ByteArrayReadableSeekableByteChannel(arr);
                result.complete((ArrowReader)new ArrowFileReader((SeekableByteChannel)byteChannel, allocator));
            }
        });
        return result;
    }

    private boolean containsError(String errString) {
        return errString != null && !"".equals(errString);
    }

    @Override
    public CompletableFuture<Void> show() {
        Runtime runtime = this.context.getRuntime();
        long runtimePointer = runtime.getPointer();
        long dataframe = this.getPointer();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        DataFrames.showDataframe(runtimePointer, dataframe, errString -> {
            if (this.containsError((String)errString)) {
                future.completeExceptionally(new RuntimeException((String)errString));
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    void doClose(long pointer) {
        DataFrames.destroyDataFrame(pointer);
    }
}

