/*
 * Decompiled with CFR 0.152.
 */
package io.github.deemru.abcode;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;

public class ABCode {
    private final byte[] a;
    private final int aq;
    private final int[] amap;
    private final byte[] b;
    private final int bq;
    private final int[] bmap;
    private static final String BASE58_ALPHABET = "123456789ABCDEFGHJKLMNPQRSTUVWXYZabcdefghijkmnopqrstuvwxyz";
    private static volatile ABCode base58Instance;

    public ABCode(String abc) {
        this(abc, null);
    }

    public ABCode(String abc, String base) {
        this.a = abc.getBytes(StandardCharsets.ISO_8859_1);
        this.aq = this.a.length;
        this.amap = ABCode.map(this.a);
        if (base == null) {
            byte[] b = new byte[256];
            for (int i = 0; i < 256; ++i) {
                b[i] = (byte)i;
            }
            this.b = b;
            this.bq = 256;
            this.bmap = null;
        } else {
            this.b = base.getBytes(StandardCharsets.ISO_8859_1);
            this.bq = this.b.length;
            this.bmap = ABCode.map(this.b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ABCode base58() {
        if (base58Instance != null) return base58Instance;
        Class<ABCode> clazz = ABCode.class;
        synchronized (ABCode.class) {
            if (base58Instance != null) return base58Instance;
            base58Instance = new ABCode(BASE58_ALPHABET);
            // ** MonitorExit[var0] (shouldn't be in output)
            return base58Instance;
        }
    }

    public String encode(byte[] data) {
        byte[] result = ABCode.abcode(data, this.b, this.bq, this.bmap, this.a, this.aq);
        return result == null ? null : new String(result, StandardCharsets.ISO_8859_1);
    }

    public String encode(String data) {
        return this.encode(data.getBytes(StandardCharsets.UTF_8));
    }

    public byte[] decode(String data) {
        return ABCode.abcode(data.getBytes(StandardCharsets.ISO_8859_1), this.a, this.aq, this.amap, this.b, this.bq);
    }

    public String decodeToString(String data) {
        byte[] result = this.decode(data);
        return result == null ? null : new String(result, StandardCharsets.UTF_8);
    }

    private static int[] map(byte[] abc) {
        int i;
        int[] map = new int[256];
        for (i = 0; i < 256; ++i) {
            map[i] = -1;
        }
        for (i = 0; i < abc.length; ++i) {
            map[abc[i] & 0xFF] = i;
        }
        return map;
    }

    private static byte[] abcode(byte[] data, byte[] from, int fromq, int[] frommap, byte[] to, int toq) {
        int z;
        int n = data.length;
        for (z = 0; z < n && data[z] == from[0]; ++z) {
        }
        if (z == n) {
            byte[] result = new byte[n];
            for (int i = 0; i < n; ++i) {
                result[i] = to[0];
            }
            return result;
        }
        if (fromq != 256) {
            for (int i = z; i < n; ++i) {
                if (frommap[data[i] & 0xFF] != -1) continue;
                return null;
            }
        }
        byte[] converted = ABCode.convert(data, z, n, fromq, frommap, toq, to);
        if (z == 0) {
            return converted;
        }
        byte[] result = new byte[z + converted.length];
        for (int i = 0; i < z; ++i) {
            result[i] = to[0];
        }
        System.arraycopy(converted, 0, result, z, converted.length);
        return result;
    }

    private static byte[] convert(byte[] data, int start, int n, int fromq, int[] frommap, int toq, byte[] to) {
        BigInteger bi;
        if (fromq == 256) {
            bi = new BigInteger(1, data);
        } else {
            long max = Long.MAX_VALUE / (long)fromq - 1L;
            long t = frommap[data[start] & 0xFF];
            long tq = fromq;
            bi = null;
            for (int i = start + 1; i < n; ++i) {
                t = t * (long)fromq + (long)frommap[data[i] & 0xFF];
                if ((tq *= (long)fromq) <= max) continue;
                BigInteger bigInteger = bi = bi == null ? BigInteger.valueOf(t) : bi.multiply(BigInteger.valueOf(tq)).add(BigInteger.valueOf(t));
                if (++i == n) {
                    tq = 1L;
                    break;
                }
                t = frommap[data[i] & 0xFF];
                tq = fromq;
            }
            if (tq != 1L) {
                BigInteger bigInteger = bi = bi == null ? BigInteger.valueOf(t) : bi.multiply(BigInteger.valueOf(tq)).add(BigInteger.valueOf(t));
            }
        }
        if (toq == 256) {
            byte[] bytes = bi.toByteArray();
            if (bytes.length > 1 && bytes[0] == 0) {
                byte[] result = new byte[bytes.length - 1];
                System.arraycopy(bytes, 1, result, 0, result.length);
                return result;
            }
            return bytes;
        }
        byte[] buf = new byte[bi.bitLength()];
        int len = 0;
        BigInteger base = BigInteger.valueOf(toq);
        while (bi.signum() > 0) {
            BigInteger[] divRem = bi.divideAndRemainder(base);
            bi = divRem[0];
            buf[len++] = to[divRem[1].intValue()];
        }
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            result[i] = buf[len - 1 - i];
        }
        return result;
    }
}

