/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.cli.validate;

import com.beust.jcommander.internal.Console;
import info.rexs.cli.validate.ValidateOptions;
import info.rexs.io.RexsFileReader;
import info.rexs.model.RexsModel;
import info.rexs.validation.IRexsModelValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessage;
import java.nio.file.Files;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class ValidateCommandServiceImpl {
    public void validate(Console console, ValidateOptions options) {
        List warnMessages;
        RexsModel rexsModel = null;
        try {
            if (Files.size(options.getFile()) < 1L) {
                console.println(String.format("The REXS file '%s' is empty.", options.getFile()));
                return;
            }
            RexsFileReader rexsFileReader = new RexsFileReader(options.getFile());
            rexsModel = rexsFileReader.read();
        }
        catch (Exception ex) {
            console.println(String.format("The REXS file '%s' could not be read (%s).", options.getFile(), ex.getMessage()));
            return;
        }
        IRexsModelValidator validator = options.getMode().createModelValidator();
        RexsValidationResult result = validator.validate(rexsModel);
        if (result.isValid()) {
            console.println("The REXS file is VALID.");
        } else {
            console.println("The REXS file is NOT VALID.");
        }
        List errorMessages = result.getErrors();
        if (errorMessages != null && !errorMessages.isEmpty()) {
            for (RexsValidationResultMessage errorMessage : errorMessages) {
                console.println("[ERROR] " + errorMessage.getDefaultMessage());
            }
        }
        if ((warnMessages = result.getWarnings()) != null && !warnMessages.isEmpty()) {
            for (RexsValidationResultMessage warnMessage : warnMessages) {
                console.println("[WARNING] " + warnMessage.getDefaultMessage());
            }
        }
    }
}

