/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.cli.convert;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import info.rexs.cli.common.RexsFileExistingValidator;
import info.rexs.cli.common.RexsFileValidator;
import info.rexs.cli.common.RexsVersionConverter;
import info.rexs.cli.common.RexsVersionParameterValidator;
import info.rexs.db.constants.RexsVersion;
import java.nio.file.Path;
import lombok.Generated;

@Parameters(commandDescription="Converts a REXS file")
public class ConvertOptions {
    @Parameter(names={"--file", "-f"}, description="The REXS file to convert (use slashes instead of backslashes)", validateValueWith={RexsFileExistingValidator.class}, required=true)
    private Path file;
    @Parameter(names={"--targetVersion"}, description="The target REXS version", validateWith={RexsVersionParameterValidator.class}, converter=RexsVersionConverter.class)
    private RexsVersion targetVersion;
    @Parameter(names={"--strict"}, description="Strict mode can be disabled if a model does not meet 100% of the specification")
    private boolean strictMode = false;
    @Parameter(names={"--targetFile"}, description="Location of the converted REXS file (use slashes instead of backslashes)", validateValueWith={RexsFileValidator.class}, required=true)
    private Path targetFile;
    @Parameter(names={"--override", "-o"}, description="Overwrite if the target file already exists")
    private boolean overrideExistingFile = false;

    @Generated
    public Path getFile() {
        return this.file;
    }

    @Generated
    public RexsVersion getTargetVersion() {
        return this.targetVersion;
    }

    @Generated
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Generated
    public Path getTargetFile() {
        return this.targetFile;
    }

    @Generated
    public boolean isOverrideExistingFile() {
        return this.overrideExistingFile;
    }

    @Generated
    public void setFile(Path file) {
        this.file = file;
    }

    @Generated
    public void setTargetVersion(RexsVersion targetVersion) {
        this.targetVersion = targetVersion;
    }

    @Generated
    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    @Generated
    public void setTargetFile(Path targetFile) {
        this.targetFile = targetFile;
    }

    @Generated
    public void setOverrideExistingFile(boolean overrideExistingFile) {
        this.overrideExistingFile = overrideExistingFile;
    }
}

