/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.xml;

import info.rexs.io.AbstractRexsFileReader;
import info.rexs.io.Resource;
import info.rexs.io.RexsIoException;
import info.rexs.model.RexsModel;
import info.rexs.model.jaxb.Accumulation;
import info.rexs.model.jaxb.Attribute;
import info.rexs.model.jaxb.Component;
import info.rexs.model.jaxb.LoadCase;
import info.rexs.model.jaxb.LoadSpectrum;
import info.rexs.model.jaxb.Model;
import info.rexs.model.transformer.RexsModelXmlTransformer;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import javax.xml.stream.StreamFilter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;

public class RexsXmlFileReader
extends AbstractRexsFileReader {
    public RexsXmlFileReader(Resource rexsInputFileResource) {
        super(rexsInputFileResource);
    }

    public RexsXmlFileReader(Path pathToRexsInputFile) {
        super(pathToRexsInputFile);
    }

    public RexsXmlFileReader(File rexsInputFile) {
        super(rexsInputFile);
    }

    public RexsXmlFileReader(String rexsInputFilePath) {
        super(rexsInputFilePath);
    }

    public Model readRawModel() throws RexsIoException {
        Model model;
        block8: {
            this.validateInputFile();
            InputStream input = this.rexsInputFileResource.openInputStream();
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Model.class});
                XMLInputFactory xmlInputFactory = XMLInputFactory.newFactory();
                XMLStreamReader xmlStreamReader = xmlInputFactory.createXMLStreamReader(new StreamSource(input));
                xmlStreamReader = xmlInputFactory.createFilteredReader(xmlStreamReader, new StreamFilter(){

                    @Override
                    public boolean accept(XMLStreamReader reader) {
                        if (reader.getEventType() == 4) {
                            return reader.getText().trim().length() > 0;
                        }
                        return true;
                    }
                });
                Unmarshaller unmarshaller = context.createUnmarshaller();
                Model rawModel = (Model)unmarshaller.unmarshal(xmlStreamReader);
                model = this.convertDegreeUnits(rawModel);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RexsIoException("error reading rexs model from xml file", ex);
                }
            }
            input.close();
        }
        return model;
    }

    @Override
    public RexsModel read() throws RexsIoException {
        try {
            Model rawModel = this.readRawModel();
            RexsModelXmlTransformer transformer = new RexsModelXmlTransformer();
            return transformer.transform(rawModel);
        }
        catch (Exception ex) {
            throw new RexsIoException("error on reading rexs model from xml file", ex);
        }
    }

    private Model convertDegreeUnits(Model model) {
        if (model.getComponents() == null || model.getComponents().getComponent().isEmpty()) {
            return model;
        }
        ArrayList<Component> allComponents = new ArrayList<Component>();
        allComponents.addAll(model.getComponents().getComponent());
        for (LoadSpectrum spectrum : model.getLoadSpectrum()) {
            for (LoadCase loadCase : spectrum.getLoadCase()) {
                allComponents.addAll(loadCase.getComponent());
            }
            Accumulation accumulation = spectrum.getAccumulation();
            if (accumulation == null) continue;
            allComponents.addAll(accumulation.getComponent());
        }
        for (Component component : allComponents) {
            for (Attribute attribute : component.getAttribute()) {
                if (attribute.getUnit() == null || !attribute.getUnit().equals(RexsStandardUnitIds.degree.getId())) continue;
                attribute.setUnit(RexsStandardUnitIds.deg.getId());
            }
        }
        return model;
    }
}

