/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.schema.constants.standard.RexsStandardAttributeIds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RexsSubModel
implements Comparable<RexsSubModel> {
    protected Map<Integer, RexsComponent> components = new HashMap<Integer, RexsComponent>();
    private Integer id;
    private boolean isAccumulation = false;

    protected RexsSubModel(Integer id, boolean isAccumulation) {
        this.id = id;
        this.isAccumulation = isAccumulation;
    }

    protected RexsSubModel(Integer id) {
        this(id, false);
    }

    protected RexsSubModel() {
        this(null, true);
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isAccumulation() {
        return this.isAccumulation;
    }

    public List<RexsComponent> getComponents() {
        return this.components.values().stream().collect(Collectors.toList());
    }

    public void addComponent(RexsComponent component) {
        this.components.put(component.getId(), component);
    }

    public boolean hasComponent(Integer compId) {
        return this.components.containsKey(compId);
    }

    public RexsComponent getComponent(Integer compId) {
        return this.components.get(compId);
    }

    public void changeComponentId(Integer oldId, Integer newId) {
        if (this.hasComponent(oldId)) {
            RexsComponent component = this.getComponent(oldId);
            component.changeComponentId(newId);
            this.components.remove(oldId);
            this.components.put(newId, component);
        }
        for (RexsComponent component : this.components.values()) {
            RexsAttribute refCompAttribute;
            if (!component.hasAttribute(RexsStandardAttributeIds.reference_component_for_position) || Integer.valueOf((refCompAttribute = component.getAttribute(RexsStandardAttributeIds.reference_component_for_position)).getStringValue()) != oldId) continue;
            refCompAttribute.setStringValue(String.valueOf(newId));
        }
    }

    @Override
    public int compareTo(RexsSubModel other) {
        if (this.isAccumulation && other.isAccumulation()) {
            return 0;
        }
        if (this.isAccumulation) {
            return 1;
        }
        if (other.isAccumulation()) {
            return -1;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsSubModel)) {
            return false;
        }
        RexsSubModel other = (RexsSubModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this_id = this.getId();
        Integer other_id = other.getId();
        if (this_id == null ? other_id != null : !((Object)this_id).equals(other_id)) {
            return false;
        }
        Boolean this_isAccumulation = this.isAccumulation();
        Boolean other_isAccumulation = other.isAccumulation();
        return this_isAccumulation == null ? other_isAccumulation == null : ((Object)this_isAccumulation).equals(other_isAccumulation);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsSubModel;
    }

    public int hashCode() {
        int result = 1;
        Integer _id = this.getId();
        result = result * 59 + (_id == null ? 43 : ((Object)_id).hashCode());
        Boolean _isAccumulation = this.isAccumulation();
        result = result * 59 + (_isAccumulation == null ? 43 : ((Object)_isAccumulation).hashCode());
        return result;
    }
}

