/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.transformer;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsLoadSpectrum;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsModelObjectFactory;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.model.RexsSubModel;
import info.rexs.model.jaxb.Accumulation;
import info.rexs.model.jaxb.Array;
import info.rexs.model.jaxb.ArrayOfArrays;
import info.rexs.model.jaxb.Attribute;
import info.rexs.model.jaxb.C;
import info.rexs.model.jaxb.CodeType;
import info.rexs.model.jaxb.Component;
import info.rexs.model.jaxb.Components;
import info.rexs.model.jaxb.LoadCase;
import info.rexs.model.jaxb.LoadSpectrum;
import info.rexs.model.jaxb.Matrix;
import info.rexs.model.jaxb.Model;
import info.rexs.model.jaxb.ObjectFactory;
import info.rexs.model.jaxb.R;
import info.rexs.model.jaxb.Ref;
import info.rexs.model.jaxb.Relation;
import info.rexs.model.jaxb.Relations;
import info.rexs.model.transformer.IRexsModelTransformer;
import info.rexs.model.util.DateUtils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.AbstractRexsAttributeValueArray;
import info.rexs.model.value.AbstractRexsAttributeValueMatrix;
import info.rexs.model.value.Base64Type;
import info.rexs.model.value.RexsAttributeValueArray;
import info.rexs.model.value.RexsAttributeValueArrayBase64;
import info.rexs.model.value.RexsAttributeValueArrayOfArrays;
import info.rexs.model.value.RexsAttributeValueMatrix;
import info.rexs.model.value.RexsAttributeValueMatrixBase64;
import info.rexs.model.value.RexsAttributeValueScalar;
import info.rexs.schema.constants.standard.RexsStandardAttributeIds;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RexsModelXmlTransformer
implements IRexsModelTransformer<Model> {
    protected ObjectFactory objectFactory = new ObjectFactory();

    @Override
    public Model transform(RexsModel model) {
        return this.createModelXml(model);
    }

    @Override
    public RexsModel transform(Model modelXml) {
        return this.createModel(modelXml);
    }

    private Model createModelXml(RexsModel model) {
        Model modelXml = this.objectFactory.createModel();
        modelXml.setApplicationId(model.getApplicationId());
        modelXml.setApplicationVersion(model.getApplicationVersion());
        modelXml.setDate(DateUtils.getISO8601Date());
        if (model.getVersion().equals(RexsStandardVersions.UNKNOWN)) {
            modelXml.setVersion(model.getOriginVersion());
        } else {
            modelXml.setVersion(model.getVersion().getName());
        }
        modelXml.setRelations(this.createRelationsXml(model.getRelations()));
        modelXml.setComponents(this.createComponentsXml(model.getComponents()));
        modelXml.getLoadSpectrum().addAll(this.createLoadSpectrumsXml(model.getLoadSpectrums()));
        return modelXml;
    }

    private Relations createRelationsXml(List<RexsRelation> relations) {
        if (relations == null || relations.isEmpty()) {
            return null;
        }
        Relations relationsXml = this.objectFactory.createRelations();
        List<RexsRelation> sortedRelations = relations.stream().sorted(Comparator.comparingInt(rel -> rel.getId())).toList();
        for (RexsRelation relation : sortedRelations) {
            relationsXml.getRelation().add(this.createRelationXml(relation));
        }
        return relationsXml;
    }

    private Relation createRelationXml(RexsRelation relation) {
        Relation relationXml = this.objectFactory.createRelation();
        relationXml.setId(relation.getId());
        relationXml.setType(relation.getType().getKey());
        if (relation.getOrder() != null && relation.getOrder() > -1) {
            relationXml.setOrder(relation.getOrder());
        }
        relationXml.getRef().addAll(this.createRefsXml(relation.getRefs()));
        return relationXml;
    }

    private List<Ref> createRefsXml(Collection<RexsRelationRef> refs) {
        if (refs == null || refs.isEmpty()) {
            return new ArrayList<Ref>();
        }
        ArrayList<Ref> refsXml = new ArrayList<Ref>();
        for (RexsRelationRef ref : refs) {
            refsXml.add(this.createRefXml(ref));
        }
        return refsXml;
    }

    private Ref createRefXml(RexsRelationRef ref) {
        Ref refXml = this.objectFactory.createRef();
        refXml.setId(ref.getId());
        refXml.setHint(ref.getHint());
        refXml.setRole(ref.getRole().getKey());
        return refXml;
    }

    private Components createComponentsXml(List<RexsComponent> components) {
        if (components == null || components.isEmpty()) {
            return null;
        }
        Components componentsXml = this.objectFactory.createComponents();
        List<RexsComponent> sortedComponents = components.stream().sorted(Comparator.comparingInt(component -> component.getId())).toList();
        for (RexsComponent component2 : sortedComponents) {
            componentsXml.getComponent().add(this.createComponentXml(component2));
        }
        return componentsXml;
    }

    private Component createComponentXml(RexsComponent component) {
        Component componentXml = this.objectFactory.createComponent();
        componentXml.setId(component.getId());
        if (component.getType().equals(RexsStandardComponentTypes.UNKNOWN)) {
            componentXml.setType(component.getOriginType());
        } else {
            componentXml.setType(component.getType().getId());
        }
        componentXml.setName(component.getName());
        componentXml.getAttribute().addAll(this.createAttributesXml(component.getAttributes()));
        return componentXml;
    }

    private List<Attribute> createAttributesXml(Collection<RexsAttribute> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return new ArrayList<Attribute>();
        }
        ArrayList<Attribute> attributesXml = new ArrayList<Attribute>();
        List<RexsAttribute> sortedAttributes = attributes.stream().sorted(Comparator.comparing(attribute -> attribute.getAttributeId().getId())).toList();
        for (RexsAttribute attribute2 : sortedAttributes) {
            attributesXml.add(this.createAttributeXml(attribute2));
        }
        return attributesXml;
    }

    private Attribute createAttributeXml(RexsAttribute attribute) {
        Object valueXml;
        Attribute attributeXml = this.objectFactory.createAttribute();
        if (attribute.getAttributeId().equals(RexsStandardAttributeIds.UNKNOWN)) {
            attributeXml.setId(attribute.getOriginAttributeId());
        } else {
            attributeXml.setId(attribute.getAttributeId().getId());
        }
        if (attribute.getUnit().equals(RexsStandardUnitIds.UNKNOWN)) {
            attributeXml.setUnit(attribute.getOriginUnit());
        } else {
            attributeXml.setUnit(attribute.getUnit().getId());
        }
        AbstractRexsAttributeValue value = attribute.getRawValue();
        if (value != null && (valueXml = this.createAttributeContentXml(value)) != null) {
            attributeXml.getContent().add(valueXml);
        }
        return attributeXml;
    }

    private Object createAttributeContentXml(AbstractRexsAttributeValue value) {
        if (value instanceof RexsAttributeValueScalar) {
            RexsAttributeValueScalar valueScalar = (RexsAttributeValueScalar)value;
            return valueScalar.getRawValue() != null ? valueScalar.getRawValue() : "";
        }
        if (value instanceof AbstractRexsAttributeValueArray) {
            return this.createArrayXml((AbstractRexsAttributeValueArray)value);
        }
        if (value instanceof AbstractRexsAttributeValueMatrix) {
            return this.createMatrixXml((AbstractRexsAttributeValueMatrix)value);
        }
        if (value instanceof RexsAttributeValueArrayOfArrays) {
            return this.createArrayOfArraysXml((RexsAttributeValueArrayOfArrays)value);
        }
        return null;
    }

    private Array createArrayXml(AbstractRexsAttributeValueArray value) {
        Array array = null;
        if (value instanceof RexsAttributeValueArray) {
            List<String> rawValue = ((RexsAttributeValueArray)value).getRawValue();
            if (rawValue == null) {
                return null;
            }
            array = this.objectFactory.createArray();
            for (String valueXml : rawValue) {
                C c = this.objectFactory.createC();
                if (valueXml == null) {
                    c.setValue("");
                } else {
                    c.setValue(valueXml);
                }
                array.getContent().add(c);
            }
        } else if (value instanceof RexsAttributeValueArrayBase64) {
            RexsAttributeValueArrayBase64 valueBase64 = (RexsAttributeValueArrayBase64)value;
            if (valueBase64.getRawValue() == null) {
                return null;
            }
            array = this.objectFactory.createArray();
            array.setCode(this.convertBase64Type(valueBase64.getRawType()));
            array.getContent().add(valueBase64.getRawValue());
        }
        return array;
    }

    private Matrix createMatrixXml(AbstractRexsAttributeValueMatrix value) {
        Matrix matrix = null;
        if (value instanceof RexsAttributeValueMatrix) {
            List<List<String>> rawValue = ((RexsAttributeValueMatrix)value).getRawValue();
            if (rawValue == null) {
                return null;
            }
            matrix = this.objectFactory.createMatrix();
            for (List<String> rawValueRow : rawValue) {
                R row = this.objectFactory.createR();
                if (rawValueRow != null) {
                    for (String rawValueCol : rawValueRow) {
                        if (rawValueCol == null) {
                            row.getC().add("");
                            continue;
                        }
                        row.getC().add(rawValueCol);
                    }
                }
                matrix.getContent().add(row);
            }
        } else if (value instanceof RexsAttributeValueMatrixBase64) {
            RexsAttributeValueMatrixBase64 valueBase64 = (RexsAttributeValueMatrixBase64)value;
            if (valueBase64.getRawValue() == null) {
                return null;
            }
            matrix = this.objectFactory.createMatrix();
            matrix.setCode(this.convertBase64Type(valueBase64.getRawType()));
            if (valueBase64.getRawRows() >= 0) {
                matrix.setRows(valueBase64.getRawRows());
            }
            if (valueBase64.getRawCols() >= 0) {
                matrix.setColumns(valueBase64.getRawCols());
            }
            matrix.getContent().add(valueBase64.getRawValue());
        }
        return matrix;
    }

    private CodeType convertBase64Type(Base64Type type) {
        if (type == Base64Type.INT_32) {
            return CodeType.INT_32;
        }
        if (type == Base64Type.FLOAT_32) {
            return CodeType.FLOAT_32;
        }
        if (type == Base64Type.FLOAT_64) {
            return CodeType.FLOAT_64;
        }
        return null;
    }

    private ArrayOfArrays createArrayOfArraysXml(RexsAttributeValueArrayOfArrays value) {
        ArrayOfArrays arrayOfArrays = this.objectFactory.createArrayOfArrays();
        List<AbstractRexsAttributeValueArray> rawValue = value.getRawValue();
        for (AbstractRexsAttributeValueArray arrayValue : rawValue) {
            arrayOfArrays.getArray().add(this.createArrayXml(arrayValue));
        }
        return arrayOfArrays;
    }

    private List<LoadSpectrum> createLoadSpectrumsXml(List<RexsLoadSpectrum> loadSpectrums) {
        if (loadSpectrums == null || loadSpectrums.isEmpty()) {
            return new ArrayList<LoadSpectrum>();
        }
        ArrayList<LoadSpectrum> loadSpectrumsXml = new ArrayList<LoadSpectrum>();
        for (RexsLoadSpectrum loadSpectrum : loadSpectrums) {
            loadSpectrumsXml.add(this.createLoadSpectrumXml(loadSpectrum));
        }
        return loadSpectrumsXml;
    }

    private LoadSpectrum createLoadSpectrumXml(RexsLoadSpectrum loadSpectrum) {
        LoadSpectrum loadSpectrumXml = this.objectFactory.createLoadSpectrum();
        loadSpectrumXml.setId(loadSpectrum.getId());
        loadSpectrumXml.getLoadCase().addAll(this.createLoadCasesXml(loadSpectrum.getLoadCases()));
        loadSpectrumXml.setAccumulation(this.createAccumulationXml(loadSpectrum.getAccumulation()));
        return loadSpectrumXml;
    }

    private List<LoadCase> createLoadCasesXml(Collection<RexsSubModel> loadCases) {
        if (loadCases == null || loadCases.isEmpty()) {
            return new ArrayList<LoadCase>();
        }
        ArrayList<LoadCase> loadCasesXml = new ArrayList<LoadCase>();
        for (RexsSubModel loadCase : loadCases) {
            loadCasesXml.add(this.createLoadCaseXml(loadCase));
        }
        return loadCasesXml;
    }

    private LoadCase createLoadCaseXml(RexsSubModel loadCase) {
        LoadCase loadCaseXml = this.objectFactory.createLoadCase();
        loadCaseXml.setId(loadCase.getId());
        List<RexsComponent> sortedComponents = loadCase.getComponents().stream().sorted(Comparator.comparingInt(component -> component.getId())).toList();
        for (RexsComponent component2 : sortedComponents) {
            loadCaseXml.getComponent().add(this.createComponentXml(component2));
        }
        return loadCaseXml;
    }

    private Accumulation createAccumulationXml(RexsSubModel accumulation) {
        if (accumulation == null) {
            return null;
        }
        List<RexsComponent> components = accumulation.getComponents();
        if (components == null || components.isEmpty()) {
            return null;
        }
        Accumulation accumulationXml = this.objectFactory.createAccumulation();
        List<RexsComponent> sortedComponents = components.stream().sorted(Comparator.comparingInt(component -> component.getId())).toList();
        for (RexsComponent component2 : sortedComponents) {
            accumulationXml.getComponent().add(this.createComponentXml(component2));
        }
        return accumulationXml;
    }

    private RexsModel createModel(Model modelXml) {
        RexsModel model = RexsModelObjectFactory.getInstance().createRexsModel(modelXml.getVersion(), modelXml.getApplicationId(), modelXml.getApplicationVersion());
        if (modelXml.getRelations() != null && modelXml.getRelations().getRelation() != null) {
            for (Relation relationXml : modelXml.getRelations().getRelation()) {
                model.addRelation(this.createRelation(relationXml));
            }
        }
        if (modelXml.getComponents() != null && modelXml.getComponents().getComponent() != null) {
            for (Component componentXml : modelXml.getComponents().getComponent()) {
                model.addComponent(this.createComponent(componentXml));
            }
        }
        if (modelXml.getLoadSpectrum() != null) {
            for (LoadSpectrum loadSpectrumXml : modelXml.getLoadSpectrum()) {
                model.addLoadSpectrum(this.createLoadSpectrum(loadSpectrumXml));
            }
        }
        return model;
    }

    private RexsRelation createRelation(Relation relationXml) {
        RexsRelation relation = RexsModelObjectFactory.getInstance().createRexsRelation((Integer)relationXml.getId(), relationXml.getType(), relationXml.getOrder());
        if (relationXml.getRef() != null) {
            for (Ref refXml : relationXml.getRef()) {
                RexsRelationRef ref = RexsModelObjectFactory.getInstance().createRexsRelationRef((Integer)refXml.getId(), refXml.getRole(), refXml.getHint());
                relation.addRef(ref);
            }
        }
        return relation;
    }

    private RexsComponent createComponent(Component componentXml) {
        RexsComponent component = RexsModelObjectFactory.getInstance().createRexsComponent((Integer)componentXml.getId(), componentXml.getType(), componentXml.getName());
        if (componentXml.getAttribute() != null) {
            for (Attribute attributeXml : componentXml.getAttribute()) {
                component.addAttribute(this.createAttribute(attributeXml));
            }
        }
        return component;
    }

    public RexsAttribute createAttribute(Attribute attributeXml) {
        String unit = attributeXml.getUnit();
        RexsAttribute attribute = unit != null ? RexsModelObjectFactory.getInstance().createRexsAttribute(attributeXml.getId(), unit) : RexsModelObjectFactory.getInstance().createRexsAttribute(attributeXml.getId());
        attribute.setRawValue(this.createAttributeValue(attributeXml));
        return attribute;
    }

    public AbstractRexsAttributeValue createAttributeValue(Attribute attributeXml) {
        List<Object> valueContent = attributeXml.getContent();
        if (valueContent == null || valueContent.isEmpty()) {
            return null;
        }
        Object value = valueContent.get(0);
        if (value instanceof String) {
            return new RexsAttributeValueScalar(((String)value).trim());
        }
        Array arrayXml = this.readArrayElement(attributeXml);
        if (arrayXml != null) {
            return this.createAttributeValue(arrayXml);
        }
        Matrix matrixXml = this.readMatrixElement(attributeXml);
        if (matrixXml != null) {
            return this.createAttributeValue(matrixXml);
        }
        ArrayOfArrays arrayOfArraysXml = this.readArrayOfArraysElement(attributeXml);
        if (arrayOfArraysXml != null) {
            return this.createAttributeValue(arrayOfArraysXml);
        }
        return null;
    }

    private AbstractRexsAttributeValueArray createAttributeValue(Array arrayXml) {
        CodeType arrayCode = this.readArrayCodeType(arrayXml);
        if (arrayCode == null) {
            List<String> value = this.readStringArrayValue(arrayXml);
            return new RexsAttributeValueArray(value);
        }
        String base64 = this.readArrayBase64Value(arrayXml);
        if (arrayCode == CodeType.INT_32) {
            return new RexsAttributeValueArrayBase64(base64, Base64Type.INT_32);
        }
        if (arrayCode == CodeType.FLOAT_32) {
            return new RexsAttributeValueArrayBase64(base64, Base64Type.FLOAT_32);
        }
        if (arrayCode == CodeType.FLOAT_64) {
            return new RexsAttributeValueArrayBase64(base64, Base64Type.FLOAT_64);
        }
        return null;
    }

    private AbstractRexsAttributeValueMatrix createAttributeValue(Matrix matrixXml) {
        CodeType matrixCode = this.readMatrixCodeType(matrixXml);
        if (matrixCode == null) {
            List<List<String>> value = this.readStringMatrixValue(matrixXml);
            return new RexsAttributeValueMatrix(value);
        }
        int rows = this.readMatrixRows(matrixXml);
        int cols = this.readMatrixCols(matrixXml);
        String base64 = this.readMatrixBase64Value(matrixXml);
        if (matrixCode == CodeType.INT_32) {
            return new RexsAttributeValueMatrixBase64(base64, Base64Type.INT_32, rows, cols);
        }
        if (matrixCode == CodeType.FLOAT_32) {
            return new RexsAttributeValueMatrixBase64(base64, Base64Type.FLOAT_32, rows, cols);
        }
        if (matrixCode == CodeType.FLOAT_64) {
            return new RexsAttributeValueMatrixBase64(base64, Base64Type.FLOAT_64, rows, cols);
        }
        return null;
    }

    private RexsAttributeValueArrayOfArrays createAttributeValue(ArrayOfArrays arrayOfArraysXml) {
        ArrayList<AbstractRexsAttributeValueArray> value = new ArrayList<AbstractRexsAttributeValueArray>();
        for (Array arrayXml : arrayOfArraysXml.getArray()) {
            value.add(this.createAttributeValue(arrayXml));
        }
        return new RexsAttributeValueArrayOfArrays(value);
    }

    private RexsLoadSpectrum createLoadSpectrum(LoadSpectrum loadSpectrumXml) {
        RexsLoadSpectrum loadSpectrum = RexsModelObjectFactory.getInstance().createRexsLoadSpectrum(loadSpectrumXml.getId());
        if (loadSpectrumXml.getLoadCase() != null) {
            for (LoadCase loadCaseXml : loadSpectrumXml.getLoadCase()) {
                loadSpectrum.addLoadCase(this.createLoadCase(loadCaseXml));
            }
        }
        if (loadSpectrumXml.getAccumulation() != null) {
            loadSpectrum.setAccumulation(this.createAccumulation(loadSpectrumXml.getAccumulation()));
        }
        return loadSpectrum;
    }

    private RexsSubModel createLoadCase(LoadCase loadCaseXml) {
        RexsSubModel loadCase = RexsModelObjectFactory.getInstance().createRexsSubModel(loadCaseXml.getId());
        if (loadCaseXml.getComponent() != null) {
            for (Component componentXml : loadCaseXml.getComponent()) {
                loadCase.addComponent(this.createComponent(componentXml));
            }
        }
        return loadCase;
    }

    private RexsSubModel createAccumulation(Accumulation accumulationXml) {
        RexsSubModel accumulation = RexsModelObjectFactory.getInstance().createRexsSubModel();
        if (accumulationXml.getComponent() != null) {
            for (Component componentXml : accumulationXml.getComponent()) {
                accumulation.addComponent(this.createComponent(componentXml));
            }
        }
        return accumulation;
    }

    private Array readArrayElement(Attribute attributeXml) {
        List<Object> valueContent = attributeXml.getContent();
        if (valueContent == null || valueContent.isEmpty()) {
            return null;
        }
        return valueContent.stream().filter(Array.class::isInstance).map(Array.class::cast).findFirst().orElse(null);
    }

    private CodeType readArrayCodeType(Array array) {
        if (array != null) {
            return array.getCode();
        }
        return null;
    }

    private List<String> readStringArrayValue(Array array) {
        if (array != null) {
            return array.getContent().stream().filter(C.class::isInstance).map(C.class::cast).map(C::getValue).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String readArrayBase64Value(Array array) {
        if (array != null) {
            return array.getContent().stream().filter(String.class::isInstance).map(String.class::cast).filter(Objects::nonNull).map(String::trim).filter(val -> !val.isEmpty()).findFirst().orElse(null);
        }
        return null;
    }

    private Matrix readMatrixElement(Attribute attributeXml) {
        List<Object> valueContent = attributeXml.getContent();
        if (valueContent == null || valueContent.isEmpty()) {
            return null;
        }
        return valueContent.stream().filter(Matrix.class::isInstance).map(Matrix.class::cast).findFirst().orElse(null);
    }

    private CodeType readMatrixCodeType(Matrix matrix) {
        if (matrix != null) {
            return matrix.getCode();
        }
        return null;
    }

    private List<List<String>> readStringMatrixValue(Matrix matrix) {
        if (matrix != null) {
            return matrix.getContent().stream().filter(R.class::isInstance).map(R.class::cast).map(R::getC).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private int readMatrixRows(Matrix matrix) {
        if (matrix != null && matrix.getRows() != null) {
            return matrix.getRows();
        }
        return -1;
    }

    private int readMatrixCols(Matrix matrix) {
        if (matrix != null && matrix.getColumns() != null) {
            return matrix.getColumns();
        }
        return -1;
    }

    private String readMatrixBase64Value(Matrix matrix) {
        if (matrix != null) {
            return matrix.getContent().stream().filter(String.class::isInstance).map(String.class::cast).filter(Objects::nonNull).map(String::trim).filter(val -> !val.isEmpty()).findFirst().orElse(null);
        }
        return null;
    }

    private ArrayOfArrays readArrayOfArraysElement(Attribute attributeXml) {
        List<Object> valueContent = attributeXml.getContent();
        if (valueContent == null || valueContent.isEmpty()) {
            return null;
        }
        return valueContent.stream().filter(ArrayOfArrays.class::isInstance).map(ArrayOfArrays.class::cast).findFirst().orElse(null);
    }
}

