/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema.constants;

import info.rexs.schema.constants.RexsRelationRole;
import info.rexs.schema.constants.standard.RexsStandardRelationTypes;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RexsRelationType
implements RexsStandardRelationTypes {
    private static Map<String, RexsRelationType> allRelationTypes = new HashMap<String, RexsRelationType>();
    private final String key;
    private final List<RexsRelationRole> roles;

    private RexsRelationType(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be empty");
        }
        this.key = key;
        this.roles = Arrays.asList(new RexsRelationRole[0]);
    }

    private RexsRelationType(String key, List<RexsRelationRole> roles) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("key cannot be empty");
        }
        this.key = key;
        this.roles = roles;
    }

    public List<RexsRelationRole> getRoles() {
        return this.roles;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isOneOf(RexsRelationType ... checkRelationTypes) {
        if (checkRelationTypes == null) {
            return false;
        }
        for (RexsRelationType checkRelationType : checkRelationTypes) {
            if (!this.equals(checkRelationType)) continue;
            return true;
        }
        return false;
    }

    public boolean isOrdered() {
        return this.key.contains("ordered");
    }

    public static RexsRelationType create(String key) {
        RexsRelationType relationType = new RexsRelationType(key);
        allRelationTypes.put(key, relationType);
        return relationType;
    }

    public static RexsRelationType create(String key, RexsRelationRole ... roles) {
        RexsRelationType relationType = new RexsRelationType(key, Arrays.asList(roles));
        allRelationTypes.put(key, relationType);
        return relationType;
    }

    public static RexsRelationType findByKey(String key) {
        if (key == null) {
            return null;
        }
        RexsStandardRelationTypes.init();
        return allRelationTypes.getOrDefault(key, null);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsRelationType)) {
            return false;
        }
        RexsRelationType other = (RexsRelationType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this_key = this.getKey();
        String other_key = other.getKey();
        return this_key == null ? other_key == null : this_key.equals(other_key);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsRelationType;
    }

    public int hashCode() {
        int result = 1;
        String _key = this.getKey();
        result = result * 59 + (_key == null ? 43 : _key.hashCode());
        return result;
    }
}

