/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema.constants;

import info.rexs.schema.constants.standard.RexsStandardVersions;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class RexsVersion
implements RexsStandardVersions,
Comparable<RexsVersion> {
    private static final Set<RexsVersion> allVerions = new HashSet<RexsVersion>();
    private final String name;
    private final int order;
    private final Set<String> alternativeNames;

    private RexsVersion(String name, int order, Set<String> alternativeNames) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be empty");
        }
        this.name = name;
        this.order = order;
        this.alternativeNames = alternativeNames;
    }

    public static RexsVersion getLatest() {
        return V1_6;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public boolean isOneOf(RexsVersion ... checkVersions) {
        if (checkVersions == null) {
            return false;
        }
        for (RexsVersion checkVersion : checkVersions) {
            if (!this.equals(checkVersion)) continue;
            return true;
        }
        return false;
    }

    public static RexsVersion create(String name, int order, String ... alternativeNames) {
        Set alternativeNamesSet = null;
        if (alternativeNames != null && alternativeNames.length > 0) {
            alternativeNamesSet = Arrays.stream(alternativeNames).collect(Collectors.toSet());
        }
        RexsVersion version = new RexsVersion(name, order, alternativeNamesSet);
        allVerions.add(version);
        return version;
    }

    public static RexsVersion findByName(String name) {
        if (name == null) {
            return UNKNOWN;
        }
        RexsStandardVersions.init();
        for (RexsVersion version : allVerions) {
            if (!name.equals(version.getName()) && (version.alternativeNames == null || !version.alternativeNames.contains(name))) continue;
            return version;
        }
        return UNKNOWN;
    }

    public boolean isLess(RexsVersion version) {
        return this.compareTo(version) < 0;
    }

    public boolean isLessOrEqual(RexsVersion version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isEqual(RexsVersion version) {
        return this.compareTo(version) == 0;
    }

    public boolean isGreater(RexsVersion version) {
        return this.compareTo(version) > 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsVersion)) {
            return false;
        }
        RexsVersion other = (RexsVersion)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Objects.equals(this.getName(), other.getName());
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsVersion;
    }

    public int hashCode() {
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        return result;
    }

    @Override
    public int compareTo(RexsVersion other) {
        return Comparator.comparing(RexsVersion::getOrder).compare(this, other);
    }
}

