/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import info.rexs.model.RexsModel;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.ModelUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import info.rexs.upgrade.upgraders.ModelUpgraderV10toV11;
import info.rexs.upgrade.upgraders.ModelUpgraderV11toV12;
import info.rexs.upgrade.upgraders.ModelUpgraderV12toV13;
import info.rexs.upgrade.upgraders.ModelUpgraderV13toV14;
import info.rexs.upgrade.upgraders.ModelUpgraderV14toV15;
import info.rexs.upgrade.upgraders.ModelUpgraderV15toV16;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UpgradeResolver {
    private static UpgradeResolver instance = null;
    private Map<RexsVersion, Map<RexsVersion, ModelUpgrader>> registeredUpgraders = new HashMap<RexsVersion, Map<RexsVersion, ModelUpgrader>>();

    private UpgradeResolver() {
        this.register(RexsStandardVersions.V1_0, RexsStandardVersions.V1_1, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV10toV11 upgrader = new ModelUpgraderV10toV11(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
        this.register(RexsStandardVersions.V1_1, RexsStandardVersions.V1_2, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV11toV12 upgrader = new ModelUpgraderV11toV12(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
        this.register(RexsStandardVersions.V1_2, RexsStandardVersions.V1_3, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV12toV13 upgrader = new ModelUpgraderV12toV13(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
        this.register(RexsStandardVersions.V1_3, RexsStandardVersions.V1_4, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV13toV14 upgrader = new ModelUpgraderV13toV14(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
        this.register(RexsStandardVersions.V1_4, RexsStandardVersions.V1_5, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV14toV15 upgrader = new ModelUpgraderV14toV15(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
        this.register(RexsStandardVersions.V1_5, RexsStandardVersions.V1_6, new ModelUpgrader(){

            @Override
            public ModelUpgraderResult upgrade(RexsModel rexsModel, boolean strictMode) throws RexsUpgradeException {
                ModelUpgraderV15toV16 upgrader = new ModelUpgraderV15toV16(rexsModel, strictMode);
                return upgrader.doupgrade();
            }
        });
    }

    public static synchronized UpgradeResolver getInstance() {
        if (instance == null) {
            instance = new UpgradeResolver();
        }
        return instance;
    }

    public void register(RexsVersion fromVersion, RexsVersion toVersion, ModelUpgrader upgrader) {
        Map toVersionRegisteredUpgraders = this.registeredUpgraders.computeIfAbsent(toVersion, k -> new HashMap());
        toVersionRegisteredUpgraders.put(fromVersion, upgrader);
    }

    public List<ModelUpgrader> resolve(RexsVersion fromVersion, RexsVersion toVersion) throws RexsUpgradeException {
        if (fromVersion == null || toVersion == null) {
            return Collections.emptyList();
        }
        Map<RexsVersion, ModelUpgrader> toVersionRegisteredUpgraders = this.registeredUpgraders.get(toVersion);
        if (toVersionRegisteredUpgraders == null) {
            return Collections.emptyList();
        }
        for (Map.Entry<RexsVersion, ModelUpgrader> toVersionRegisteredUpgradersEntry : toVersionRegisteredUpgraders.entrySet()) {
            RexsVersion possibleFromVersion = toVersionRegisteredUpgradersEntry.getKey();
            if (fromVersion.equals(possibleFromVersion)) {
                return Stream.of(toVersionRegisteredUpgradersEntry.getValue()).collect(Collectors.toList());
            }
            List<ModelUpgrader> upgraders = this.resolve(fromVersion, possibleFromVersion);
            if (upgraders.isEmpty()) continue;
            upgraders.add(toVersionRegisteredUpgradersEntry.getValue());
            return upgraders;
        }
        return Collections.emptyList();
    }
}

