/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.constants.RexsRelationRole;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.validation.RexsStandardRelationValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.ArrayList;
import java.util.List;

public class RexsModellingGuidelineQuasistaticRelationValidator
extends RexsStandardRelationValidator {
    public RexsModellingGuidelineQuasistaticRelationValidator(RexsVersion rexsVersion) {
        super(rexsVersion);
    }

    public RexsModellingGuidelineQuasistaticRelationValidator(RexsVersion rexsVersion, IRexsSchemaRegistry rexsSchemaRegistry) {
        super(rexsVersion, rexsSchemaRegistry);
    }

    @Override
    public RexsValidationResult validate(RexsRelation rexsRelation, RexsModel rexsModel) {
        int numRoles;
        RexsValidationResult validationResult = super.validate(rexsRelation, rexsModel);
        List<RexsRelationRole> rolesOfRelationType = rexsRelation.getType().getRoles();
        int numRefs = rexsRelation.getRefs().size();
        if (numRefs != (numRoles = rolesOfRelationType.size())) {
            List<RexsRelationRole> rolesInRelation = rexsRelation.getRefs().stream().map(r -> r.getRole()).toList();
            ArrayList<String> messageList = new ArrayList<String>();
            messageList.add(String.valueOf(rexsRelation.getId()));
            messageList.addAll(rolesOfRelationType.stream().filter(r -> !rolesInRelation.contains(r)).map(r -> r.getKey()).toList());
            String[] additionalMessages = new String[messageList.size()];
            for (int i = 0; i < messageList.size(); ++i) {
                additionalMessages[i] = (String)messageList.get(i);
            }
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_RELATION_MISSING_ROLES, additionalMessages);
        }
        return validationResult;
    }
}

