/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsComponent;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.RexsSchemaRegistry;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.schema.constants.standard.RexsStandardRelationTypes;
import info.rexs.validation.DefaultRexsModelValidator;
import info.rexs.validation.IRexsComponentValidator;
import info.rexs.validation.IRexsRelationValidator;
import info.rexs.validation.RexsStandardComponentValidator;
import info.rexs.validation.RexsStandardRelationValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.List;
import java.util.Objects;

public class RexsStandardModelValidator
extends DefaultRexsModelValidator {
    protected final IRexsSchemaRegistry rexsSchemaRegistry;
    protected RexsVersion rexsVersion = null;

    public RexsStandardModelValidator() {
        this(RexsSchemaRegistry.getInstance());
    }

    public RexsStandardModelValidator(IRexsSchemaRegistry rexsSchemaRegistry) {
        Objects.nonNull(rexsSchemaRegistry);
        this.rexsSchemaRegistry = rexsSchemaRegistry;
    }

    @Override
    protected RexsValidationResult validateVersion(String version) {
        RexsValidationResult validationResult = super.validateVersion(version);
        if (version == null || version.isEmpty()) {
            return validationResult;
        }
        this.rexsVersion = this.rexsSchemaRegistry.getVersion(version);
        if (this.rexsVersion == null) {
            validationResult.addError(RexsValidationResultMessageKey.MODEL_VERSION_UNKNOWN, new String[0]);
        }
        return validationResult;
    }

    @Override
    public RexsValidationResult validate(RexsModel rexsModel) {
        RexsValidationResult validationResult = super.validate(rexsModel);
        if (!this.rexsSchemaRegistry.hasRelationTypes(this.rexsVersion)) {
            validationResult.addWarning(RexsValidationResultMessageKey.RELATION_NO_TYPES_FOR_VERSION, this.rexsVersion.getName());
        }
        validationResult.add(this.checkPlanetaryStage(rexsModel));
        return validationResult;
    }

    private RexsValidationResult checkPlanetaryStage(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        for (RexsComponent planetaryStage : rexsModel.getComponentsOfType(RexsStandardComponentTypes.planetary_stage)) {
            List<RexsRelation> relationsOfPlanetaryStage;
            if (rexsModel.getSubComponentsWithType(planetaryStage.getId(), RexsStandardComponentTypes.planet_carrier).size() != 1) {
                validationResult.addError(RexsValidationResultMessageKey.PLANETARY_STAGE_INCONSISTENT_CARRIER, String.valueOf(planetaryStage.getId()));
            }
            if (rexsModel.getSubComponentsWithType(planetaryStage.getId(), RexsStandardComponentTypes.cylindrical_stage).isEmpty()) {
                validationResult.addError(RexsValidationResultMessageKey.PLANETARY_STAGE_MISSING_STAGE, String.valueOf(planetaryStage.getId()));
            }
            if ((relationsOfPlanetaryStage = rexsModel.getRelationsOfMainComp(planetaryStage.getId())).stream().noneMatch(r -> r.getType() == RexsStandardRelationTypes.planet_shaft)) {
                validationResult.addError(RexsValidationResultMessageKey.PLANETARY_STAGE_MISSING_PLANET_SHAFT, String.valueOf(planetaryStage.getId()));
            }
            if (!relationsOfPlanetaryStage.stream().noneMatch(r -> r.getType() == RexsStandardRelationTypes.central_shaft)) continue;
            validationResult.addError(RexsValidationResultMessageKey.PLANETARY_STAGE_MISSING_CENTRAL_SHAFT, String.valueOf(planetaryStage.getId()));
        }
        return validationResult;
    }

    @Override
    public IRexsComponentValidator createComponentValidator() {
        if (this.rexsVersion == null) {
            return super.createComponentValidator();
        }
        return new RexsStandardComponentValidator(this.rexsVersion, this.rexsSchemaRegistry);
    }

    @Override
    public IRexsRelationValidator createRelationValidator() {
        if (this.rexsVersion == null) {
            return super.createRelationValidator();
        }
        return new RexsStandardRelationValidator(this.rexsVersion, this.rexsSchemaRegistry);
    }
}

