/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.FileResource;
import info.rexs.io.Resource;
import info.rexs.io.RexsIoException;
import info.rexs.model.RexsModel;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public abstract class AbstractRexsFileReader {
    protected final Resource rexsInputFileResource;

    protected AbstractRexsFileReader(Resource rexsInputFileResource) {
        this.rexsInputFileResource = rexsInputFileResource;
    }

    protected AbstractRexsFileReader(Path pathToRexsInputFile) {
        this(new FileResource(pathToRexsInputFile));
    }

    protected AbstractRexsFileReader(File rexsInputFile) {
        this(rexsInputFile.toPath());
    }

    protected AbstractRexsFileReader(String rexsInputFilePath) {
        this(Paths.get(rexsInputFilePath, new String[0]));
    }

    protected void validateInputFile() throws RexsIoException {
        if (!this.rexsInputFileResource.exists()) {
            throw new RexsIoException("rexs file " + this.rexsInputFileResource.getFilename() + " does not exist");
        }
    }

    public abstract RexsModel read() throws RexsIoException;
}

