/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.rexs.io.AbstractRexsFileReader;
import info.rexs.io.Resource;
import info.rexs.io.RexsIoException;
import info.rexs.io.json.model.Accumulation;
import info.rexs.io.json.model.Component;
import info.rexs.io.json.model.JSONModel;
import info.rexs.io.json.model.LoadCase;
import info.rexs.io.json.model.LoadSpectrum;
import info.rexs.io.json.model.Model;
import info.rexs.io.json.model.attributes.Attribute;
import info.rexs.model.RexsModel;
import info.rexs.model.transformer.RexsModelJsonTransformer;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class RexsJsonFileReader
extends AbstractRexsFileReader {
    public RexsJsonFileReader(Resource rexsInputFileResource) {
        super(rexsInputFileResource);
    }

    public RexsJsonFileReader(Path pathToRexsInputFile) {
        super(pathToRexsInputFile);
    }

    public RexsJsonFileReader(File rexsInputFile) {
        super(rexsInputFile);
    }

    public RexsJsonFileReader(String rexsInputFilePath) {
        super(rexsInputFilePath);
    }

    private JSONModel readRawModel() throws RexsIoException {
        JSONModel jSONModel;
        block8: {
            this.validateInputFile();
            InputStream input = this.rexsInputFileResource.openInputStream();
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
                String text = reader.lines().collect(Collectors.joining(System.lineSeparator()));
                ObjectMapper mapper = new ObjectMapper();
                text = text.replace("\ufeff", "");
                jSONModel = (JSONModel)mapper.readerFor(JSONModel.class).readValue(text);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    throw new RexsIoException("error reading rexs model from json file", ex);
                }
            }
            input.close();
        }
        return jSONModel;
    }

    @Override
    public RexsModel read() throws RexsIoException {
        this.validateInputFile();
        try {
            JSONModel jsonModel = this.readRawModel();
            this.convertDegreeUnits(jsonModel.getModel());
            return new RexsModelJsonTransformer().transform(jsonModel);
        }
        catch (Exception ex) {
            throw new RexsIoException("error reading rexs model from json file", ex);
        }
    }

    private void convertDegreeUnits(Model model) {
        if (model.getComponents() == null || model.getComponents().isEmpty()) {
            return;
        }
        ArrayList<Component> allComponents = new ArrayList<Component>();
        allComponents.addAll(model.getComponents());
        LoadSpectrum spectrum = model.getLoadSpectrum();
        if (spectrum != null) {
            for (LoadCase loadCase : spectrum.getLoadCases()) {
                allComponents.addAll(loadCase.getComponents());
            }
            Accumulation accumulation = spectrum.getAccumulation();
            if (accumulation != null) {
                allComponents.addAll(accumulation.getComponents());
            }
        }
        for (Component component : allComponents) {
            for (Attribute attribute : component.getAttributes()) {
                if (attribute.getUnit() == null || !attribute.getUnit().equals(RexsStandardUnitIds.degree.getId())) continue;
                attribute.setUnit(RexsStandardUnitIds.deg.getId());
            }
        }
    }
}

