/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.value;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.value.AbstractRexsAttributeValue;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public class RexsAttributeValueScalar
extends AbstractRexsAttributeValue {
    private String value = null;

    public RexsAttributeValueScalar() {
    }

    public RexsAttributeValueScalar(String value) {
        this.value = value;
    }

    @Override
    public boolean hasValue() {
        return this.value != null && !this.value.isEmpty();
    }

    @Override
    public AbstractRexsAttributeValue copy() {
        return new RexsAttributeValueScalar(this.value);
    }

    @Override
    public boolean getValueBoolean() throws RexsModelAccessException {
        Boolean val = null;
        if (!this.value.equals("false") && !this.value.equals("true")) {
            throw new RexsModelAccessException("boolean value cannot be " + this.value);
        }
        if (this.value != null && !this.value.isEmpty()) {
            val = Boolean.valueOf(this.value);
        }
        if (val == null) {
            throw new RexsModelAccessException("boolean value cannot be null");
        }
        return val;
    }

    @Override
    public String getValueString() {
        return this.value;
    }

    @Override
    public int getValueInteger() throws RexsModelAccessException {
        Integer val = null;
        if (this.value != null && !this.value.isEmpty()) {
            try {
                val = Integer.parseInt(this.value);
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read integer value " + this.value, ex);
            }
        }
        if (val == null) {
            throw new RexsModelAccessException("int value cannot be null");
        }
        return val;
    }

    @Override
    public double getValueDouble() throws RexsModelAccessException {
        Double val = null;
        if (this.value != null && !this.value.isEmpty()) {
            try {
                val = Double.parseDouble(this.value);
            }
            catch (NumberFormatException ex) {
                throw new RexsModelAccessException("cannot read double value " + this.value, ex);
            }
        }
        if (val == null) {
            throw new RexsModelAccessException("double value cannot be null");
        }
        return val;
    }

    public void setValueBoolean(boolean value) {
        this.value = Boolean.toString(value);
    }

    public void setValueString(String value) {
        this.value = value;
    }

    public void setValueInteger(int value) {
        this.value = Integer.toString(value);
    }

    public void setValueDouble(double value) {
        this.value = Double.toString(value);
    }

    public String getRawValue() {
        return this.value;
    }

    public void setValueTime(OffsetDateTime time) {
        this.value = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(time);
    }

    @Override
    public OffsetDateTime getValueDateTime() {
        return OffsetDateTime.parse(this.value, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }
}

