/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema;

import info.rexs.schema.RexsSchemaFileResolver;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class RexsSchemaFile {
    private static final RexsSchemaFileResolver DEFAULT_FILE_RESOLVER = new RexsSchemaFileResolver();
    private static Set<RexsSchemaFile> allRexsSchemaFiles = new HashSet<RexsSchemaFile>();
    public static final RexsSchemaFile V1_0 = RexsSchemaFile.create(RexsStandardVersions.V1_0);
    public static final RexsSchemaFile V1_1 = RexsSchemaFile.create(RexsStandardVersions.V1_1);
    public static final RexsSchemaFile V1_2 = RexsSchemaFile.create(RexsStandardVersions.V1_2);
    public static final RexsSchemaFile V1_3 = RexsSchemaFile.create(RexsStandardVersions.V1_3);
    public static final RexsSchemaFile V1_4 = RexsSchemaFile.create(RexsStandardVersions.V1_4);
    public static final RexsSchemaFile V1_5 = RexsSchemaFile.create(RexsStandardVersions.V1_5);
    public static final RexsSchemaFile V1_6 = RexsSchemaFile.create(RexsStandardVersions.V1_6);
    private final RexsVersion version;
    private final RexsSchemaFileResolver fileResolver;

    private RexsSchemaFile(RexsVersion version, RexsSchemaFileResolver fileResolver) {
        if (version == null) {
            throw new IllegalArgumentException("version cannot be empty");
        }
        this.version = version;
        this.fileResolver = fileResolver;
    }

    public RexsVersion getVersion() {
        return this.version;
    }

    public InputStream openInputStream() {
        return this.fileResolver.openInputStream(this);
    }

    public static RexsSchemaFile create(RexsVersion version, RexsSchemaFileResolver fileResolver) {
        if (fileResolver == null) {
            fileResolver = DEFAULT_FILE_RESOLVER;
        }
        RexsSchemaFile rexsSchemaFile = new RexsSchemaFile(version, fileResolver);
        allRexsSchemaFiles.add(rexsSchemaFile);
        return rexsSchemaFile;
    }

    public static RexsSchemaFile create(RexsVersion version) {
        return RexsSchemaFile.create(version, null);
    }

    public static RexsSchemaFile findByVersion(RexsVersion version) {
        if (version == null) {
            return null;
        }
        for (RexsSchemaFile rexsSchemaFile : allRexsSchemaFiles) {
            if (!version.equals(rexsSchemaFile.version)) continue;
            return rexsSchemaFile;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsSchemaFile)) {
            return false;
        }
        RexsSchemaFile other = (RexsSchemaFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RexsVersion this_version = this.getVersion();
        RexsVersion other_version = other.getVersion();
        return Objects.equals(this_version, other_version);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsSchemaFile;
    }

    public int hashCode() {
        int result = 1;
        RexsVersion _version = this.getVersion();
        result = result * 59 + (_version == null ? 43 : ((Object)_version).hashCode());
        return result;
    }
}

