/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema;

import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.RexsSchemaResolver;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsRelationType;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsValueType;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import info.rexs.schema.jaxb.AllowedCombination;
import info.rexs.schema.jaxb.AllowedCombinationRole;
import info.rexs.schema.jaxb.Attribute;
import info.rexs.schema.jaxb.Component;
import info.rexs.schema.jaxb.ComponentAttributeMapping;
import info.rexs.schema.jaxb.EnumValue;
import info.rexs.schema.jaxb.Relation;
import info.rexs.schema.jaxb.RexsSchema;
import info.rexs.schema.jaxb.Unit;
import info.rexs.schema.jaxb.ValueType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class RexsSchemaRegistry
implements IRexsSchemaRegistry {
    private static RexsSchemaRegistry instance = null;
    private Map<String, RexsVersion> versions = new HashMap<String, RexsVersion>();
    private Map<RexsVersion, Map<String, RexsComponentType>> componentMap = new HashMap<RexsVersion, Map<String, RexsComponentType>>();
    private Map<RexsVersion, Map<String, RexsUnitId>> attributeUnits = new HashMap<RexsVersion, Map<String, RexsUnitId>>();
    private Map<RexsVersion, Map<String, RexsValueType>> attributeTypes = new HashMap<RexsVersion, Map<String, RexsValueType>>();
    private Map<RexsVersion, Map<String, Attribute>> attributeMap = new HashMap<RexsVersion, Map<String, Attribute>>();
    private Map<RexsVersion, Map<String, List<RexsComponentType>>> attributeToComponentMap = new HashMap<RexsVersion, Map<String, List<RexsComponentType>>>();
    private Map<RexsVersion, Map<RexsComponentType, List<String>>> componentToAttributesMap = new HashMap<RexsVersion, Map<RexsComponentType, List<String>>>();
    private Map<RexsVersion, Map<RexsRelationType, List<List<AllowedCombinationRole>>>> relationsToAllowedCombinationsMap = new HashMap<RexsVersion, Map<RexsRelationType, List<List<AllowedCombinationRole>>>>();

    private RexsSchemaRegistry() {
        try {
            this.registerRexsVersion(RexsStandardVersions.V1_0);
            this.registerRexsVersion(RexsStandardVersions.V1_1);
            this.registerRexsVersion(RexsStandardVersions.V1_2);
            this.registerRexsVersion(RexsStandardVersions.V1_3);
            this.registerRexsVersion(RexsStandardVersions.V1_4);
            this.registerRexsVersion(RexsStandardVersions.V1_5);
            this.registerRexsVersion(RexsStandardVersions.V1_6);
        }
        catch (Exception ex) {
            throw new RuntimeException("error while registering rexs model:", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RexsSchemaRegistry getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<RexsSchemaRegistry> clazz = RexsSchemaRegistry.class;
        synchronized (RexsSchemaRegistry.class) {
            if (instance == null) {
                instance = new RexsSchemaRegistry();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerRexsVersion(RexsVersion version) {
        RexsSchema rexsSchema = RexsSchemaResolver.getInstance().resolve(version);
        if (rexsSchema == null) {
            throw new IllegalStateException(String.format("rexs db model for version %s not found", version.getModelVersion()));
        }
        this.registerRexsSchema(version, rexsSchema);
        this.versions.put(version.getModelVersion(), version);
    }

    private void registerRexsSchema(RexsVersion version, RexsSchema rexsSchema) {
        this.generateComponentMap(version, rexsSchema);
        this.generateAttributeMap(version, rexsSchema);
        this.generateAttributeTypeMap(version, rexsSchema);
        this.generateAttributeUnitMap(version, rexsSchema);
        this.generateAttributeComponentMappings(version, rexsSchema);
        this.generateRelationsWithAllowedCombinations(version, rexsSchema);
    }

    private void generateRelationsWithAllowedCombinations(RexsVersion version, RexsSchema rexsSchema) {
        Map relationsToAllowedCombinationsMapofVersion = this.relationsToAllowedCombinationsMap.computeIfAbsent(version, k -> new HashMap());
        if (rexsSchema.getRelations() != null) {
            for (Relation relation : rexsSchema.getRelations()) {
                RexsRelationType relationType = RexsRelationType.findByKey(relation.getRelationId());
                List listOfCombinations = relationsToAllowedCombinationsMapofVersion.computeIfAbsent(relationType, k -> new ArrayList());
                for (AllowedCombination combination : relation.getAllowedCombinations()) {
                    listOfCombinations.add(combination.getAllowedCombinationRole());
                }
            }
        }
    }

    private void generateComponentMap(RexsVersion version, RexsSchema rexsSchema) {
        Map mapOfVersion = this.componentMap.computeIfAbsent(version, k -> new HashMap());
        for (Component component : rexsSchema.getComponents()) {
            RexsComponentType componentType = RexsComponentType.findById(component.getComponentId());
            mapOfVersion.put(component.getComponentId(), componentType);
        }
    }

    private void generateAttributeMap(RexsVersion version, RexsSchema rexsSchema) {
        Map mapofVersion = this.attributeMap.computeIfAbsent(version, k -> new HashMap());
        for (Attribute attribute : rexsSchema.getAttributes()) {
            mapofVersion.put(attribute.getAttributeId(), attribute);
        }
    }

    private void generateAttributeTypeMap(RexsVersion version, RexsSchema rexsSchema) {
        Map mapofVersion = this.attributeTypes.computeIfAbsent(version, k -> new HashMap());
        HashMap<Integer, String> valueTypeMap = new HashMap<Integer, String>();
        if (rexsSchema.getValueTypes() != null) {
            for (ValueType valueType : rexsSchema.getValueTypes()) {
                valueTypeMap.put(valueType.getId(), valueType.getName());
            }
        }
        if (rexsSchema.getAttributes() != null) {
            for (Attribute attribute : rexsSchema.getAttributes()) {
                mapofVersion.put(attribute.getAttributeId(), RexsValueType.findByKey((String)valueTypeMap.get(attribute.getValueType())));
            }
        }
    }

    private void generateAttributeUnitMap(RexsVersion version, RexsSchema rexsSchema) {
        Map mapofVersion = this.attributeUnits.computeIfAbsent(version, k -> new HashMap());
        HashMap<Integer, String> unitMap = new HashMap<Integer, String>();
        if (rexsSchema.getUnits() != null) {
            for (Unit unit : rexsSchema.getUnits()) {
                if (RexsStandardUnitIds.degree.getId().equals(unit.getName())) {
                    unitMap.put(unit.getId(), RexsStandardUnitIds.deg.getId());
                    continue;
                }
                unitMap.put(unit.getId(), unit.getName());
            }
        }
        if (rexsSchema.getAttributes() != null) {
            for (Attribute attribute : rexsSchema.getAttributes()) {
                String unit = (String)unitMap.get(attribute.getUnit());
                mapofVersion.put(attribute.getAttributeId(), RexsUnitId.findById(unit));
            }
        }
    }

    @Override
    public RexsUnitId getAttributeUnit(String rexsAttributeId, RexsVersion version) {
        Map<String, RexsUnitId> unitsMap = this.attributeUnits.get(version);
        if (unitsMap != null && unitsMap.containsKey(rexsAttributeId)) {
            return unitsMap.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getModelVersion()));
    }

    @Override
    public RexsValueType getAttributeType(String rexsAttributeId, RexsVersion version) {
        Map<String, RexsValueType> map = this.attributeTypes.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getModelVersion()));
    }

    @Override
    public String getAttributeName(String attributeId, RexsVersion version) {
        if (!this.attributeMap.get(version).containsKey(attributeId)) {
            return attributeId;
        }
        Attribute attribute = this.attributeMap.get(version).get(attributeId);
        if (RexsSchemaRegistry.getLanguageDefaultLocale().equals("de")) {
            return attribute.getNameDe();
        }
        return attribute.getNameEn();
    }

    @Override
    public String getAttributeSymbol(String attributeId, RexsVersion version) {
        if (!this.attributeMap.get(version).containsKey(attributeId)) {
            return "";
        }
        return this.attributeMap.get(version).get(attributeId).getSymbol();
    }

    @Override
    public String getNameForEnumValue(String attributeId, RexsVersion version, String value) {
        Attribute attribute = this.attributeMap.get(version).get(attributeId);
        for (EnumValue enumValue : attribute.getEnumValues()) {
            if (!enumValue.getValue().equals(value)) continue;
            if (RexsSchemaRegistry.getLanguageDefaultLocale().equals("de")) {
                return enumValue.getNameDe();
            }
            return enumValue.getNameEn();
        }
        return value;
    }

    private void generateAttributeComponentMappings(RexsVersion version, RexsSchema rexsSchema) {
        Map attributeToComponentMapofVersion = this.attributeToComponentMap.computeIfAbsent(version, k -> new HashMap());
        Map componentToAttributeMapofVersion = this.componentToAttributesMap.computeIfAbsent(version, k -> new HashMap());
        if (rexsSchema.getComponentAttributeMappings() != null) {
            for (ComponentAttributeMapping mapping : rexsSchema.getComponentAttributeMappings()) {
                RexsComponentType componentType = RexsComponentType.findById(mapping.getComponentId());
                String attributeId = mapping.getAttributeId();
                List componentsOfAttributeList = attributeToComponentMapofVersion.computeIfAbsent(attributeId, k -> new ArrayList());
                List attributesOfComponentList = componentToAttributeMapofVersion.computeIfAbsent(componentType, k -> new ArrayList());
                componentsOfAttributeList.add(componentType);
                attributesOfComponentList.add(attributeId);
            }
        }
    }

    @Override
    public boolean componentAttributeMappingExists(String rexsAttributeId, RexsComponentType rexsCompType, RexsVersion version) {
        Map<String, List<RexsComponentType>> map = this.attributeToComponentMap.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId).contains(rexsCompType);
        }
        return false;
    }

    @Override
    public List<RexsComponentType> getAvailableComponentTypesForAttributeId(String rexsAttributeId, RexsVersion version) {
        Map<String, List<RexsComponentType>> map = this.attributeToComponentMap.get(version);
        if (map != null && map.containsKey(rexsAttributeId)) {
            return map.get(rexsAttributeId);
        }
        throw new IllegalArgumentException(String.format("Rexs Attribute with id %s is not registered in RexsVersion %s", rexsAttributeId, version.getModelVersion()));
    }

    @Override
    public List<String> getAttributeIdsOfComponentType(RexsComponentType rexsComponentType, RexsVersion version) {
        Map<RexsComponentType, List<String>> map = this.componentToAttributesMap.get(version);
        if (map != null && map.containsKey(rexsComponentType)) {
            return map.get(rexsComponentType);
        }
        throw new IllegalArgumentException(String.format("Rexs component type %s is not registered in RexsVersion %s", rexsComponentType, version.getModelVersion()));
    }

    @Override
    public RexsVersion getVersion(String version) {
        return this.versions.get(version);
    }

    @Override
    public RexsComponentType getComponentType(RexsVersion version, String componentType) {
        Map<String, RexsComponentType> map = this.componentMap.get(version);
        if (map != null && map.containsKey(componentType)) {
            return map.get(componentType);
        }
        return RexsStandardComponentTypes.UNKNOWN;
    }

    @Override
    public boolean hasAttributeWithId(RexsVersion version, String attributeId) {
        Map<String, Attribute> map = this.attributeMap.get(version);
        return map != null && map.containsKey(attributeId);
    }

    private static String getLanguageDefaultLocale() {
        Locale locale = Locale.getDefault();
        if (!locale.getLanguage().equalsIgnoreCase("en") && !locale.getLanguage().equalsIgnoreCase("de")) {
            return Locale.ENGLISH.getLanguage();
        }
        return locale.getLanguage();
    }

    @Override
    public boolean hasRelationTypes(RexsVersion version) {
        Map<RexsRelationType, List<List<AllowedCombinationRole>>> relationsToAllowedCombinationsMapOfVersion = this.relationsToAllowedCombinationsMap.get(version);
        return relationsToAllowedCombinationsMapOfVersion != null && !relationsToAllowedCombinationsMapOfVersion.isEmpty();
    }

    @Override
    public List<List<AllowedCombinationRole>> getAllowedCombinationsForRelation(RexsVersion version, RexsRelationType relationType) {
        Map<RexsRelationType, List<List<AllowedCombinationRole>>> relationsToAllowedCombinationsMapOfVersion = this.relationsToAllowedCombinationsMap.get(version);
        if (relationsToAllowedCombinationsMapOfVersion == null) {
            throw new IllegalArgumentException(String.format("No relation types for REXS version %s specified", version.getModelVersion()));
        }
        List<List<AllowedCombinationRole>> listOfAllowedCombinations = relationsToAllowedCombinationsMapOfVersion.get(relationType);
        if (listOfAllowedCombinations == null || listOfAllowedCombinations.isEmpty()) {
            throw new IllegalArgumentException(String.format("Rexs Relation type %s is not defined in version %s", relationType, version.getModelVersion()));
        }
        return listOfAllowedCombinations;
    }
}

