/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema;

import info.rexs.schema.RexsSchemaFile;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.jaxb.RexsSchema;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class RexsSchemaResolver {
    private static RexsSchemaResolver instance = null;
    private Map<RexsSchemaFile, RexsSchema> rexsSchemaFileCache = new HashMap<RexsSchemaFile, RexsSchema>();

    private RexsSchemaResolver() {
    }

    public static synchronized RexsSchemaResolver getInstance() {
        if (instance == null) {
            instance = new RexsSchemaResolver();
        }
        return instance;
    }

    public RexsSchema resolve(RexsVersion version) {
        RexsSchemaFile rexsSchemaFile = RexsSchemaFile.findByVersion(version);
        if (rexsSchemaFile == null) {
            return null;
        }
        if (this.rexsSchemaFileCache.containsKey(rexsSchemaFile)) {
            return this.rexsSchemaFileCache.get(rexsSchemaFile);
        }
        RexsSchema rexsSchema = null;
        try (InputStream input = rexsSchemaFile.openInputStream();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RexsSchema.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            rexsSchema = (RexsSchema)unmarshaller.unmarshal(input);
        }
        catch (Exception ex) {
            throw new IllegalStateException(String.format("could not load rexs schema for version %s", rexsSchemaFile.getVersion()), ex);
        }
        this.rexsSchemaFileCache.put(rexsSchemaFile, rexsSchema);
        return rexsSchema;
    }
}

