/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema.constants;

import info.rexs.schema.constants.standard.RexsStandardVersions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RexsVersion {
    private static final String DEV_VERSION_NAME = "DEV";
    public static final RexsVersion DEV = new RexsVersion("DEV", null, "DEV");
    public static final RexsVersion UNKNOWN = new RexsVersion("UNKNOWN", null, "UNKNOWN");
    private static final Map<String, RexsVersion> allModelVersions = new HashMap<String, RexsVersion>();
    private final String schemaVersion;
    private final String schemaProvider;
    private final String modelVersion;

    private RexsVersion(String schemaVersion, String schemaProvider, String modelVersion) {
        this.schemaVersion = schemaVersion;
        this.schemaProvider = schemaProvider;
        this.modelVersion = modelVersion;
    }

    public static RexsVersion create(String schemaVersion, String schemaProvider, String primaryModelVersion, String ... additionalModelVersions) {
        if (schemaVersion == null || schemaVersion.isEmpty()) {
            throw new IllegalArgumentException("The schema version cannot be empty");
        }
        if (schemaProvider != null && schemaProvider.isEmpty()) {
            schemaProvider = null;
        }
        if (primaryModelVersion == null || primaryModelVersion.isEmpty()) {
            throw new IllegalArgumentException("The primary model version cannot be empty");
        }
        for (String additionalModelVersion : additionalModelVersions) {
            if (additionalModelVersion != null && !additionalModelVersion.isEmpty()) continue;
            throw new IllegalArgumentException("Additional model versions cannot contain empty entries");
        }
        if (!schemaVersion.matches("\\d+\\.\\d+") && !schemaVersion.equalsIgnoreCase(DEV_VERSION_NAME)) {
            throw new IllegalArgumentException("schemaVersion must follow the pattern X.X");
        }
        RexsVersion primaryVersion = new RexsVersion(schemaVersion, schemaProvider, primaryModelVersion);
        allModelVersions.put(primaryVersion.getModelVersion(), primaryVersion);
        for (String additionalModelVersion : additionalModelVersions) {
            allModelVersions.put(additionalModelVersion, primaryVersion);
        }
        return primaryVersion;
    }

    public static RexsVersion findByModelVersion(String modelVersion) {
        if (modelVersion == null) {
            return UNKNOWN;
        }
        if (modelVersion.equalsIgnoreCase(DEV.getModelVersion())) {
            return DEV;
        }
        for (RexsVersion version : allModelVersions.values()) {
            if (!modelVersion.equalsIgnoreCase(version.getModelVersion())) continue;
            return version;
        }
        return UNKNOWN;
    }

    public static RexsVersion findBySchema(String schemaVersion, String schemaProvider) {
        if (schemaVersion == null) {
            return UNKNOWN;
        }
        if (schemaProvider != null && schemaProvider.isEmpty()) {
            schemaProvider = null;
        }
        for (RexsVersion version : allModelVersions.values()) {
            if (!(schemaProvider == null ? schemaVersion.equalsIgnoreCase(version.getSchemaVersion()) && version.schemaProvider == null : schemaVersion.equalsIgnoreCase(version.getSchemaVersion()) && schemaProvider.equalsIgnoreCase(version.getSchemaProvider()))) continue;
            return version;
        }
        return UNKNOWN;
    }

    public String getSchemaVersion() {
        return this.schemaVersion;
    }

    public String getSchemaProvider() {
        return this.schemaProvider;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public int getNumericVersion() {
        if (this == UNKNOWN) {
            return -1;
        }
        if (this.getSchemaVersion().equalsIgnoreCase(DEV_VERSION_NAME)) {
            return Integer.MAX_VALUE;
        }
        String[] parts = this.schemaVersion.split("\\.");
        int major = Integer.parseInt(parts[0]);
        int minor = Integer.parseInt(parts[1]);
        return 10000 * major + 100 * minor;
    }

    public int compareTo(RexsVersion other) {
        return Integer.compare(this.getNumericVersion(), other.getNumericVersion());
    }

    public boolean isLessThan(RexsVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEquivalentTo(RexsVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(RexsVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEquivalentTo(RexsVersion other) {
        return this.compareTo(other) >= 0;
    }

    public boolean isEquivalentTo(RexsVersion other) {
        return this.compareTo(other) == 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RexsVersion) {
            RexsVersion other = (RexsVersion)o;
            if (this.schemaProvider != null) {
                return this.schemaVersion.equals(other.schemaVersion) && this.schemaProvider.equals(other.schemaProvider);
            }
            return this.schemaVersion.equals(other.schemaVersion) && other.schemaProvider == null;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.schemaVersion, this.schemaProvider);
    }

    static {
        RexsStandardVersions.init();
    }
}

