/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class UpgradeNotifications {
    private List<Notification> notifications = new ArrayList<Notification>();

    public UpgradeNotifications() {
    }

    public UpgradeNotifications(List<Notification> notifications) {
        this.notifications.addAll(notifications);
    }

    public void add(Notification notification) {
        this.notifications.add(notification);
    }

    public void addAll(Collection<Notification> notification) {
        this.notifications.addAll(notification);
    }

    public List<Notification> getNotifications() {
        return this.notifications;
    }

    public static class RelationSource
    implements Source {
        public final int relationId;

        public RelationSource(int relationId) {
            this.relationId = relationId;
        }

        public String toString() {
            return "Relation " + this.relationId;
        }
    }

    public static class AttributeSource
    implements Source {
        public final String attributeId;

        public AttributeSource(int attributeId) {
            this.attributeId = Integer.toString(attributeId);
        }

        public AttributeSource(String attributeId) {
            this.attributeId = attributeId;
        }

        public String toString() {
            return "Attribute " + this.attributeId;
        }
    }

    public static class ComponentSource
    implements Source {
        public final int componentId;

        public ComponentSource(int componentId) {
            this.componentId = componentId;
        }

        public String toString() {
            return "Component " + this.componentId;
        }
    }

    public static interface Source {
    }

    public static class Notification {
        private final NotificationType type;
        private final String message;
        private final List<Source> sources;

        public Notification(String message, Source ... sources) {
            this.type = NotificationType.INFO;
            this.message = message;
            this.sources = Arrays.asList(sources);
        }

        public Notification(NotificationType type, String message, Source ... sources) {
            this.type = type;
            this.message = message;
            this.sources = Arrays.asList(sources);
        }

        public NotificationType getType() {
            return this.type;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMessageVerbose() {
            String sourceStr = this.sources.stream().map(Object::toString).reduce((a, b) -> a + ", " + b).orElse("");
            return this.type + ": " + this.message + " [" + sourceStr + "]";
        }
    }

    public static enum NotificationType {
        INFO,
        WARNING,
        FIXME,
        ERROR;

    }
}

