/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.zip;

import info.rexs.io.AbstractRexsFileWriter;
import info.rexs.io.RexsIoException;
import info.rexs.io.xml.RexsXmlFileWriter;
import info.rexs.model.RexsModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.ZipOutputStream;

public class RexsZipFileWriter
extends AbstractRexsFileWriter {
    public RexsZipFileWriter(Path pathToRexsOutputFile) {
        super(pathToRexsOutputFile);
    }

    public RexsZipFileWriter(File rexsOutputFile) {
        super(rexsOutputFile);
    }

    public RexsZipFileWriter(String rexsOutputFilePath) {
        super(rexsOutputFilePath);
    }

    @Override
    public void write(RexsModel model) throws RexsIoException {
        this.createNewArchive();
        try (FileSystem fileStorageFileSystem = FileSystems.newFileSystem(this.pathToRexsOutputFile);){
            Path pathToFileInArchive = fileStorageFileSystem.getPath("/rexs-model.rexs", new String[0]);
            RexsXmlFileWriter rexsXmlFileWriter = new RexsXmlFileWriter(pathToFileInArchive);
            rexsXmlFileWriter.write(model);
        }
        catch (Exception ex) {
            throw new RexsIoException("error on writing rexs model to zip file", ex);
        }
    }

    private void createNewArchive() throws RexsIoException {
        if (Files.exists(this.pathToRexsOutputFile, new LinkOption[0])) {
            try {
                Files.delete(this.pathToRexsOutputFile);
            }
            catch (IOException ex) {
                throw new RexsIoException("rexs archive already exists and cannot be deleted", ex);
            }
        } else {
            Path pathToRexsOutputFileDirectory = this.pathToRexsOutputFile.getParent();
            if (pathToRexsOutputFileDirectory != null && !Files.exists(pathToRexsOutputFileDirectory, new LinkOption[0])) {
                throw new RexsIoException("directory " + pathToRexsOutputFileDirectory + " does not exist");
            }
        }
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(this.pathToRexsOutputFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));){
            out.setLevel(0);
            out.closeEntry();
        }
        catch (IOException ex) {
            throw new RexsIoException("error on createing new rexs zip archive");
        }
    }
}

