/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.RexsAttributeValueArray;
import info.rexs.model.value.RexsAttributeValueArrayBase64;
import info.rexs.model.value.RexsAttributeValueArrayOfArrays;
import info.rexs.model.value.RexsAttributeValueMatrix;
import info.rexs.model.value.RexsAttributeValueMatrixBase64;
import info.rexs.model.value.RexsAttributeValueScalar;
import info.rexs.schema.constants.RexsAttributeId;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsValueType;
import info.rexs.schema.constants.standard.RexsStandardAttributeIds;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class RexsAttribute {
    private RexsAttributeId attributeId;
    private String originAttributeId;
    private RexsUnitId unit;
    private String originUnit;
    private AbstractRexsAttributeValue value = null;

    protected RexsAttribute(String attributeId, String unit) {
        Objects.requireNonNull(attributeId, "attribute id cannot be empty");
        this.attributeId = RexsAttributeId.findById(attributeId);
        this.originAttributeId = attributeId;
        Objects.requireNonNull(unit, "unit cannot be empty");
        this.unit = RexsUnitId.findById(unit);
        this.originUnit = unit;
        if (this.unit == RexsStandardUnitIds.UNKNOWN) {
            this.unit = RexsUnitId.create(this.originUnit);
        }
        if (this.attributeId == RexsStandardAttributeIds.UNKNOWN) {
            this.attributeId = RexsAttributeId.create(this.originAttributeId, this.unit);
        }
    }

    protected RexsAttribute(String attributeId) {
        this(attributeId, RexsStandardUnitIds.none.toString());
    }

    protected RexsAttribute(RexsAttributeId attributeId) {
        Objects.requireNonNull(attributeId, "attribute id cannot be empty");
        this.attributeId = attributeId;
        this.originAttributeId = attributeId.getId();
        this.unit = attributeId.getUnit();
        this.originUnit = this.unit.getId();
    }

    public RexsAttribute(RexsAttribute attribute) {
        this(attribute.attributeId);
        if (attribute.value != null) {
            this.setRawValue(attribute.value.copy());
        }
    }

    public RexsAttributeId getAttributeId() {
        return this.attributeId;
    }

    public String getOriginAttributeId() {
        return this.originAttributeId;
    }

    public RexsUnitId getUnit() {
        return this.unit;
    }

    public void setUnit(RexsUnitId unit) {
        this.unit = unit;
        this.originUnit = unit.getId();
    }

    public String getOriginUnit() {
        return this.originUnit;
    }

    public AbstractRexsAttributeValue getRawValue() {
        return this.value;
    }

    public void setRawValue(AbstractRexsAttributeValue value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null && this.value.hasValue();
    }

    private void checkValue() {
        if (!this.hasValue()) {
            throw new RexsModelAccessException("value cannot be null for attribute " + this.getAttributeId().getId());
        }
    }

    public String getStringValue() {
        this.checkValue();
        return this.value.getValueString();
    }

    public OffsetDateTime getDateTimeValue() {
        this.checkValue();
        return this.value.getValueDateTime();
    }

    public boolean getBooleanValue() {
        this.checkValue();
        return this.value.getValueBoolean();
    }

    public int getIntegerValue() {
        this.checkValue();
        return this.value.getValueInteger();
    }

    public double getDoubleValue(RexsUnitId unit) {
        this.checkValue();
        this.checkUnit(unit);
        return this.value.getValueDouble();
    }

    public String[] getStringArrayValue() {
        this.checkValue();
        return this.value.getValueStringArray();
    }

    public String[] getEnumArrayValue() {
        this.checkValue();
        return this.value.getValueStringArray();
    }

    public Boolean[] getBooleanArrayValue() {
        this.checkValue();
        return this.value.getValueBooleanArray();
    }

    public Integer[] getIntegerArrayValue() {
        this.checkValue();
        return this.value.getValueIntegerArray();
    }

    public int[] getIntegerArrayValueUnboxed() {
        this.checkValue();
        return this.value.getValueIntegerArrayUnboxed();
    }

    public Double[] getDoubleArrayValue(RexsUnitId unit) {
        this.checkValue();
        this.checkUnit(unit);
        return this.value.getValueDoubleArray();
    }

    public double[] getDoubleArrayValueUnboxed(RexsUnitId unit) {
        this.checkValue();
        this.checkUnit(unit);
        return this.value.getValueDoubleArrayUnboxed();
    }

    public String[][] getStringMatrixValue() {
        this.checkValue();
        return this.value.getValueStringMatrix();
    }

    public Boolean[][] getBooleanMatrixValue() {
        this.checkValue();
        return this.value.getValueBooleanMatrix();
    }

    public Integer[][] getIntegerMatrixValue() {
        this.checkValue();
        return this.value.getValueIntegerMatrix();
    }

    public int[][] getIntegerMatrixValueUnboxed() {
        this.checkValue();
        return this.value.getValueIntegerMatrixUnboxed();
    }

    public Double[][] getDoubleMatrixValue(RexsUnitId unit) {
        this.checkValue();
        this.checkUnit(unit);
        return this.value.getValueDoubleMatrix();
    }

    public double[][] getDoubleMatrixValueUnboxed(RexsUnitId unit) {
        this.checkValue();
        this.checkUnit(unit);
        return this.value.getValueDoubleMatrixUnboxed();
    }

    public List<Integer[]> getArrayOfIntegerArraysValue() {
        this.checkValue();
        return this.value.getValueArrayOfIntegerArrays();
    }

    public Object getValue(RexsValueType type) throws RexsModelAccessException {
        switch (type) {
            case DATE_TIME: {
                return this.getDateTimeValue();
            }
            case BOOLEAN: {
                return this.getBooleanValue();
            }
            case BOOLEAN_ARRAY: {
                return this.getBooleanArrayValue();
            }
            case BOOLEAN_MATRIX: {
                return this.getBooleanMatrixValue();
            }
            case STRING: {
                return this.getStringValue();
            }
            case STRING_ARRAY: {
                return this.getStringArrayValue();
            }
            case STRING_MATRIX: {
                return this.getStringMatrixValue();
            }
            case INTEGER: {
                return this.getIntegerValue();
            }
            case INTEGER_ARRAY: {
                return this.getIntegerArrayValue();
            }
            case INTEGER_MATRIX: {
                return this.getIntegerMatrixValue();
            }
            case ARRAY_OF_INTEGER_ARRAYS: {
                return this.getArrayOfIntegerArraysValue();
            }
            case FLOATING_POINT: {
                return this.getDoubleValue(this.getUnit());
            }
            case FLOATING_POINT_ARRAY: {
                return this.getDoubleArrayValue(this.getUnit());
            }
            case FLOATING_POINT_MATRIX: {
                return this.getDoubleMatrixValue(this.getUnit());
            }
            case ENUM: {
                return this.getStringValue();
            }
            case ENUM_ARRAY: {
                return this.getStringArrayValue();
            }
            case REFERENCE_COMPONENT: 
            case FILE_REFERENCE: {
                return this.getStringValue();
            }
        }
        return this.getStringValue();
    }

    private void checkUnit(RexsUnitId unitToCheck) {
        if (!this.attributeId.getUnit().equals(unitToCheck) && this.attributeId.getUnit() != RexsStandardUnitIds.UNKNOWN && !this.attributeId.getUnit().isEquivalent(unitToCheck)) {
            throw new RexsModelAccessException(String.format("incompatible units (%s <-> %s) on %s attribute", this.attributeId.getUnit().getId(), unitToCheck.getId(), this.attributeId.getId()));
        }
    }

    public void setStringValue(String value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueScalar)) {
            this.value = new RexsAttributeValueScalar();
        }
        ((RexsAttributeValueScalar)this.value).setValueString(value);
    }

    public void setTimeValue(OffsetDateTime value) {
        this.value = new RexsAttributeValueScalar();
        ((RexsAttributeValueScalar)this.value).setValueTime(value);
    }

    public void setBooleanValue(boolean value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueScalar)) {
            this.value = new RexsAttributeValueScalar();
        }
        ((RexsAttributeValueScalar)this.value).setValueBoolean(value);
    }

    public void setIntegerValue(int value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueScalar)) {
            this.value = new RexsAttributeValueScalar();
        }
        ((RexsAttributeValueScalar)this.value).setValueInteger(value);
    }

    public void setDoubleValue(double value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueScalar)) {
            this.value = new RexsAttributeValueScalar();
        }
        ((RexsAttributeValueScalar)this.value).setValueDouble(value);
    }

    public void setStringArrayValue(String[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueStringArray(value);
    }

    public void setEnumArrayValue(String[] value) {
        this.setStringArrayValue(value);
    }

    public void setBooleanArrayValue(Boolean[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueBooleanArray(value);
    }

    public void setIntegerArrayValue(Integer[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueIntegerArray(value);
    }

    public void setIntegerArrayValue(int[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueIntegerArray(value);
    }

    public void setIntegerArrayValueBase64(int[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArrayBase64)) {
            this.value = new RexsAttributeValueArrayBase64();
        }
        ((RexsAttributeValueArrayBase64)this.value).setValueIntegerArray(value);
    }

    public void setDoubleArrayValue(Double[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueDoubleArray(value);
    }

    public void setDoubleArrayValue(double[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueDoubleArray(value);
    }

    public void setDoubleArrayValue(float[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArray)) {
            this.value = new RexsAttributeValueArray();
        }
        ((RexsAttributeValueArray)this.value).setValueDoubleArray(value);
    }

    public void setDoubleArrayValueBase64(float[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArrayBase64)) {
            this.value = new RexsAttributeValueArrayBase64();
        }
        ((RexsAttributeValueArrayBase64)this.value).setValueDoubleArray(value);
    }

    public void setDoubleArrayValueBase64(double[] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArrayBase64)) {
            this.value = new RexsAttributeValueArrayBase64();
        }
        ((RexsAttributeValueArrayBase64)this.value).setValueDoubleArray(value);
    }

    public void setStringMatrixValue(String[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueStringMatrix(value);
    }

    public void setBooleanMatrixValue(Boolean[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueBooleanMatrix(value);
    }

    public void setIntegerMatrixValue(Integer[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueIntegerMatrix(value);
    }

    public void setIntegerMatrixValue(int[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueIntegerMatrix(value);
    }

    public void setIntegerMatrixValueBase64(int[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrixBase64)) {
            this.value = new RexsAttributeValueMatrixBase64();
        }
        ((RexsAttributeValueMatrixBase64)this.value).setValueIntegerMatrix(value);
    }

    public void setDoubleMatrixValue(Double[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueDoubleMatrix(value);
    }

    public void setDoubleMatrixValue(double[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueDoubleMatrix(value);
    }

    public void setDoubleMatrixValue(float[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrix)) {
            this.value = new RexsAttributeValueMatrix();
        }
        ((RexsAttributeValueMatrix)this.value).setValueDoubleMatrix(value);
    }

    public void setDoubleMatrixValueBase64(float[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrixBase64)) {
            this.value = new RexsAttributeValueMatrixBase64();
        }
        ((RexsAttributeValueMatrixBase64)this.value).setValueDoubleMatrix(value);
    }

    public void setDoubleMatrixValueBase64(double[][] value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueMatrixBase64)) {
            this.value = new RexsAttributeValueMatrixBase64();
        }
        ((RexsAttributeValueMatrixBase64)this.value).setValueDoubleMatrix(value);
    }

    public void setArrayOfIntegerArraysValue(List<Integer[]> value) {
        if (this.value == null || !(this.value instanceof RexsAttributeValueArrayOfArrays)) {
            this.value = new RexsAttributeValueArrayOfArrays();
        }
        ((RexsAttributeValueArrayOfArrays)this.value).setValueArrayOfIntegerArrays(value);
    }

    public void setId(RexsAttributeId id) {
        this.attributeId = id;
    }
}

