/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.schema.constants;

import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class RexsComponentType
implements RexsStandardComponentTypes {
    private static Map<String, RexsComponentType> allComponentTypes = new HashMap<String, RexsComponentType>();
    private final String id;

    private RexsComponentType(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id cannot be empty");
        }
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }

    public boolean isOneOf(RexsComponentType ... checkComponentTypes) {
        if (checkComponentTypes == null) {
            return false;
        }
        for (RexsComponentType checkComponentType : checkComponentTypes) {
            if (!this.equals(checkComponentType)) continue;
            return true;
        }
        return false;
    }

    public static RexsComponentType create(String id) {
        RexsComponentType componentType = new RexsComponentType(id);
        allComponentTypes.put(id, componentType);
        return componentType;
    }

    public static RexsComponentType findById(String id) {
        if (id == null) {
            return null;
        }
        RexsStandardComponentTypes.init();
        return allComponentTypes.getOrDefault(id, RexsStandardComponentTypes.UNKNOWN);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsComponentType)) {
            return false;
        }
        RexsComponentType other = (RexsComponentType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this_id = this.getId();
        String other_id = other.getId();
        return Objects.equals(this_id, other_id);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsComponentType;
    }

    public int hashCode() {
        int result = 1;
        String _id = this.getId();
        result = result * 59 + (_id == null ? 43 : _id.hashCode());
        return result;
    }
}

