/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsModel;
import info.rexs.model.value.RexsAttributeValueScalar;
import info.rexs.schema.constants.RexsAttributeId;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsValueType;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.UpgradeNotifications;
import info.rexs.upgrade.upgraders.changelog.jaxb.AttributeChange;
import info.rexs.upgrade.upgraders.changelog.jaxb.ChangeType;
import info.rexs.upgrade.upgraders.changelog.jaxb.ChangedValue;
import info.rexs.upgrade.upgraders.changelog.jaxb.ComponentChange;
import info.rexs.upgrade.upgraders.changelog.jaxb.EnumValueChange;
import info.rexs.upgrade.upgraders.changelog.jaxb.MappingChange;
import info.rexs.upgrade.upgraders.changelog.jaxb.RexsChangelog;
import java.util.ArrayList;
import java.util.List;

public class ModelChangelogUpgrader {
    private final RexsModel newModel;
    private final RexsModel oldModel;
    private final RexsChangelog changelog;
    private UpgradeNotifications notifications = new UpgradeNotifications();
    private boolean strictMode;

    public ModelChangelogUpgrader(RexsModel model, RexsChangelog changelog, boolean strictMode) {
        this.oldModel = model;
        this.newModel = new RexsModel(model);
        this.changelog = changelog;
        this.strictMode = strictMode;
    }

    public RexsModel applyChangelog() throws RexsUpgradeException {
        if (this.changelog.getComponentChanges() != null) {
            for (ComponentChange componentChange : this.changelog.getComponentChanges()) {
                if (componentChange.getType() == ChangeType.DELETE) {
                    this.deleteComponentsByType(this.newModel, componentChange.getId());
                }
                if (componentChange.getType() != ChangeType.EDIT) continue;
                this.editComponentsByType(componentChange.getId(), componentChange.getChangedValues());
            }
        }
        if (this.changelog.getMappingChanges() != null) {
            for (MappingChange mappingChange : this.changelog.getMappingChanges()) {
                if (mappingChange.getType() != ChangeType.DELETE) continue;
                if (this.strictMode) {
                    this.deleteAttributesByComponentTypeAndAttributeId(this.newModel, mappingChange.getComponentId(), mappingChange.getAttributeId());
                    continue;
                }
                this.notifyAboutOutdatedAttributeMapping(mappingChange.getComponentId(), mappingChange.getAttributeId());
            }
        }
        if (this.changelog.getAttributeChanges() != null) {
            for (AttributeChange attributeChange : this.changelog.getAttributeChanges()) {
                if (attributeChange.getType() != ChangeType.EDIT) continue;
                this.editAttributesById(attributeChange.getId(), attributeChange.getChangedValues());
            }
        }
        return this.newModel;
    }

    private void notifyAboutOutdatedAttributeMapping(String componentType, String attributeId) {
        List<RexsComponent> affectedComponents = this.newModel.getComponentsOfType(RexsComponentType.findById(componentType)).stream().filter(c -> c.getAttributes().stream().anyMatch(a -> a.getAttributeId().getId().equals(attributeId))).toList();
        for (RexsComponent component : affectedComponents) {
            this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "Attribute is no longer available for this component type: ", new UpgradeNotifications.ComponentSource(component.getId()), new UpgradeNotifications.AttributeSource(attributeId)));
        }
    }

    private void editComponentsByType(String componentType, List<ChangedValue> changedValues) {
        for (RexsComponent component : this.oldModel.getComponents()) {
            if (!component.getType().getId().equals(componentType)) continue;
            for (ChangedValue changedValue : changedValues) {
                if (!"componentId".equals(changedValue.getKey())) continue;
                RexsComponentType compType = RexsComponentType.findById(changedValue.getNewValue());
                component.setType(compType);
            }
        }
    }

    private void deleteComponentsByType(RexsModel rexsModel, String componentType) {
        ArrayList<RexsComponent> componentsToDelete = new ArrayList<RexsComponent>();
        for (RexsComponent component : rexsModel.getComponents()) {
            if (!component.getType().getId().equals(componentType)) continue;
            componentsToDelete.add(component);
        }
        for (RexsComponent componentToDelete : componentsToDelete) {
            rexsModel.removeComponent(componentToDelete);
            this.notifications.add(new UpgradeNotifications.Notification("removed component", new UpgradeNotifications.ComponentSource(componentToDelete.getId())));
        }
    }

    private void deleteAttributesByComponentTypeAndAttributeId(RexsModel rexsModel, String componentType, String attributeId) {
        for (RexsComponent component : rexsModel.getComponents()) {
            if (!component.getType().getId().equals(componentType)) continue;
            this.deleteAttributesById(component, attributeId);
        }
    }

    private void deleteAttributesById(RexsComponent component, String attributeId) {
        ArrayList<RexsAttribute> attributesToDelete = new ArrayList<RexsAttribute>();
        for (RexsAttribute attribute : component.getAttributes()) {
            if (!attribute.getAttributeId().getId().equals(attributeId)) continue;
            attributesToDelete.add(attribute);
        }
        for (RexsAttribute attributeToDelete : attributesToDelete) {
            component.removeAttribute(attributeToDelete.getAttributeId());
            this.notifications.add(new UpgradeNotifications.Notification("removed attribute", new UpgradeNotifications.ComponentSource(component.getId()), new UpgradeNotifications.AttributeSource(attributeId)));
        }
    }

    private void editAttributesById(String attributeId, List<ChangedValue> changedValues) throws RexsUpgradeException {
        for (RexsComponent component : this.newModel.getComponents()) {
            for (RexsAttribute attribute : component.getAttributes()) {
                if (!attribute.getAttributeId().getId().equals(attributeId)) continue;
                block30: for (ChangedValue changedValue : changedValues) {
                    switch (changedValue.getKey()) {
                        case "attributeId": {
                            RexsAttributeId id = RexsAttributeId.findById(changedValue.getNewValue());
                            attribute.setId(id);
                            continue block30;
                        }
                        case "numericId": {
                            continue block30;
                        }
                        case "unit": {
                            if (changedValue.getOldValue().equals("\u00b0") && changedValue.getNewValue().equals("deg")) {
                                attribute.setUnit(RexsStandardUnitIds.deg);
                            } else if (changedValue.getOldValue().equals("N") && changedValue.getNewValue().equals("N / mm")) {
                                attribute.setUnit(RexsStandardUnitIds.newton_per_mm);
                                this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "unit conversion from N to N/mm", new UpgradeNotifications.AttributeSource(attribute.getAttributeId().getId())));
                            } else {
                                throw new RuntimeException("unsupported unit conversion");
                            }
                            RexsUnitId unit = RexsUnitId.findById(changedValue.getNewValue());
                            attribute.setUnit(unit);
                            continue block30;
                        }
                        case "symbol": {
                            continue block30;
                        }
                        case "name": {
                            continue block30;
                        }
                        case "valuetype": {
                            RexsValueType oldType = RexsValueType.findByKey(changedValue.getOldValue());
                            RexsValueType newType = RexsValueType.findByKey(changedValue.getNewValue());
                            this.editAttributeValueType(component, attribute, oldType, newType);
                            continue block30;
                        }
                        case "range": {
                            continue block30;
                        }
                        case "rangeMin": {
                            continue block30;
                        }
                        case "rangeMax": {
                            continue block30;
                        }
                        case "rangeMinIntervalOpen": {
                            continue block30;
                        }
                        case "rangeMaxIntervalOpen": {
                            continue block30;
                        }
                        case "enumvalues": {
                            this.changeEnumValue(attribute, changedValue);
                            continue block30;
                        }
                    }
                    throw new RuntimeException("unknown key " + changedValue.getKey());
                }
            }
        }
    }

    private void changeEnumValue(RexsAttribute attribute, ChangedValue changedValue) {
        block5: for (EnumValueChange enumChange : changedValue.getEnumValueChanges()) {
            switch (enumChange.getType()) {
                case ADD: {
                    continue block5;
                }
                case DELETE: {
                    continue block5;
                }
                case EDIT: {
                    String attrValue = attribute.getStringValue();
                    if (!attrValue.equals(enumChange.getValue())) continue block5;
                    ChangedValue changedEnumValue = enumChange.getChangedValues().get(0);
                    String newName = changedEnumValue.getNewValue();
                    attribute.setStringValue(newName);
                    continue block5;
                }
            }
            throw new RuntimeException("unknown enum change type");
        }
    }

    private void editAttributeValueType(RexsComponent component, RexsAttribute attribute, RexsValueType oldType, RexsValueType newType) {
        String rawValue = attribute.getRawValue().getValueString();
        switch (newType) {
            case BOOLEAN: {
                switch (rawValue) {
                    case "true": {
                        attribute.setRawValue(new RexsAttributeValueScalar("true"));
                        break;
                    }
                    case "false": {
                        attribute.setRawValue(new RexsAttributeValueScalar("false"));
                        break;
                    }
                    default: {
                        if (this.strictMode) {
                            component.removeAttribute(attribute.getAttributeId());
                        }
                        this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "value could not be converted to boolean", new UpgradeNotifications.AttributeSource(attribute.getAttributeId().getId())));
                    }
                }
            }
            case INTEGER: {
                try {
                    attribute.setRawValue(new RexsAttributeValueScalar(rawValue));
                }
                catch (NumberFormatException e) {
                    if (this.strictMode) {
                        component.removeAttribute(attribute.getAttributeId());
                    }
                    this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "value could not be converted to integer", new UpgradeNotifications.AttributeSource(attribute.getAttributeId().getId())));
                }
                break;
            }
            case FLOATING_POINT: {
                try {
                    attribute.setRawValue(new RexsAttributeValueScalar(rawValue));
                }
                catch (NumberFormatException e) {
                    if (this.strictMode) {
                        component.removeAttribute(attribute.getAttributeId());
                    }
                    this.notifications.add(new UpgradeNotifications.Notification(UpgradeNotifications.NotificationType.WARNING, "value could not be converted to float", new UpgradeNotifications.AttributeSource(attribute.getAttributeId().getId())));
                }
                break;
            }
            case ENUM: {
                break;
            }
            default: {
                throw new RuntimeException("unsupported type conversion to " + newType);
            }
        }
    }

    public UpgradeNotifications getNotifications() {
        return this.notifications;
    }
}

