/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsComponent;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.validation.DefaultRexsComponentValidator;
import info.rexs.validation.DefaultRexsRelationValidator;
import info.rexs.validation.IRexsComponentValidator;
import info.rexs.validation.IRexsModelValidator;
import info.rexs.validation.IRexsRelationValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;

public class DefaultRexsModelValidator
implements IRexsModelValidator {
    @Override
    public RexsValidationResult validate(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        validationResult.add(this.validateVersion(rexsModel.getOriginVersion()));
        if (rexsModel.getComponents() == null || rexsModel.getComponents().isEmpty()) {
            validationResult.addError(RexsValidationResultMessageKey.MODEL_COMPONENTS_EMPTY, new String[0]);
            return validationResult;
        }
        IRexsComponentValidator componentValidator = this.createComponentValidator();
        for (RexsComponent rexsComponent : rexsModel.getComponents()) {
            validationResult.add(componentValidator.validate(rexsComponent));
        }
        IRexsRelationValidator relationValidator = this.createRelationValidator();
        for (RexsRelation rexsRelation : rexsModel.getRelations()) {
            validationResult.add(relationValidator.validate(rexsRelation, rexsModel));
        }
        return validationResult;
    }

    protected RexsValidationResult validateVersion(String version) {
        RexsValidationResult validationResult = new RexsValidationResult();
        if (version == null || version.isEmpty()) {
            validationResult.addError(RexsValidationResultMessageKey.MODEL_VERSION_EMPTY, new String[0]);
        }
        return validationResult;
    }

    @Override
    public IRexsComponentValidator createComponentValidator() {
        return new DefaultRexsComponentValidator();
    }

    @Override
    public IRexsRelationValidator createRelationValidator() {
        return new DefaultRexsRelationValidator();
    }
}

