/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsComponent;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.RexsSchemaRegistry;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.validation.DefaultRexsComponentValidator;
import info.rexs.validation.IRexsAttributeValidator;
import info.rexs.validation.RexsStandardAttributeValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.Objects;

public class RexsStandardComponentValidator
extends DefaultRexsComponentValidator {
    protected final IRexsSchemaRegistry rexsSchemaRegistry;
    protected final RexsVersion rexsVersion;

    public RexsStandardComponentValidator(RexsVersion rexsVersion) {
        this(rexsVersion, RexsSchemaRegistry.getInstance());
    }

    public RexsStandardComponentValidator(RexsVersion rexsVersion, IRexsSchemaRegistry rexsSchemaRegistry) {
        Objects.nonNull(rexsSchemaRegistry);
        this.rexsVersion = rexsVersion;
        this.rexsSchemaRegistry = rexsSchemaRegistry;
    }

    @Override
    public RexsValidationResult validate(RexsComponent rexsComponent) {
        RexsValidationResult validationResult = super.validate(rexsComponent);
        if (this.rexsVersion == null) {
            return validationResult;
        }
        String componentType = rexsComponent.getOriginType();
        RexsComponentType rexsComponentType = this.rexsSchemaRegistry.getComponentType(this.rexsVersion, componentType);
        if (rexsComponentType.isOneOf(RexsStandardComponentTypes.UNKNOWN)) {
            validationResult.addError(RexsValidationResultMessageKey.COMPONENT_TYPE_UNKNOWN, componentType);
        }
        return validationResult;
    }

    @Override
    public IRexsAttributeValidator createAttributeValidator() {
        if (this.rexsVersion == null) {
            return super.createAttributeValidator();
        }
        return new RexsStandardAttributeValidator(this.rexsVersion, this.rexsSchemaRegistry);
    }
}

