/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.RexsIoException;
import info.rexs.model.RexsModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;

public abstract class AbstractRexsFileWriter {
    protected final Path pathToRexsOutputFile;

    protected AbstractRexsFileWriter(Path pathToRexsOutputFile) {
        this.pathToRexsOutputFile = pathToRexsOutputFile;
    }

    protected AbstractRexsFileWriter(File rexsOutputFile) {
        this(rexsOutputFile.toPath());
    }

    protected AbstractRexsFileWriter(String rexsOutputFilePath) {
        this(Paths.get(rexsOutputFilePath, new String[0]));
    }

    protected void validateOutputFile() throws RexsIoException {
        if (!Files.exists(this.pathToRexsOutputFile, new LinkOption[0])) {
            Path pathToRexsOutputFileDirectory = this.pathToRexsOutputFile.getParent();
            if (pathToRexsOutputFileDirectory != null && !Files.exists(pathToRexsOutputFileDirectory, new LinkOption[0])) {
                throw new RexsIoException("directory " + String.valueOf(pathToRexsOutputFileDirectory) + " does not exist");
            }
            try {
                Files.createFile(this.pathToRexsOutputFile, new FileAttribute[0]);
            }
            catch (IOException ex) {
                throw new RexsIoException("error creating new rexs file", ex);
            }
        }
        if (!Files.isWritable(this.pathToRexsOutputFile)) {
            throw new RexsIoException("file " + String.valueOf(this.pathToRexsOutputFile) + " is not writable");
        }
    }

    public abstract void write(RexsModel var1) throws RexsIoException;
}

