/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsModelAccessException;
import info.rexs.model.RexsModelObjectFactory;
import info.rexs.schema.constants.RexsAttributeId;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsValueType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RexsComponent
implements Comparable<RexsComponent> {
    private Integer id;
    private RexsComponentType type;
    private String originType;
    private String name;
    private Map<String, RexsAttribute> attributes = new HashMap<String, RexsAttribute>();

    protected RexsComponent(Integer id, String type, String name) {
        this.id = id;
        this.type = RexsComponentType.findById(type);
        this.originType = type;
        this.name = name;
    }

    protected RexsComponent(Integer id, RexsComponentType type, String name) {
        this.id = id;
        this.type = type;
        this.originType = type.getId();
        this.name = name;
    }

    public RexsComponent(RexsComponent component) {
        this.id = component.id;
        this.type = component.type;
        this.originType = component.originType;
        this.name = component.name;
        for (RexsAttribute attribute : component.getAttributes()) {
            RexsAttribute newAttribute = new RexsAttribute(attribute);
            this.addAttribute(newAttribute);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public RexsComponentType getType() {
        return this.type;
    }

    public String getOriginType() {
        return this.originType;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Collection<RexsAttribute> getAttributes() {
        return Collections.unmodifiableCollection(this.attributes.values());
    }

    public void removeAttribute(RexsAttributeId attributeId) {
        this.attributes.remove(attributeId.getId());
    }

    public boolean hasAttribute(RexsAttributeId attributeId) {
        return this.hasAttribute(attributeId.getId());
    }

    public boolean hasAttribute(String attributeId) {
        return this.attributes.containsKey(attributeId);
    }

    public RexsAttribute getAttribute(RexsAttributeId attributeId) {
        return this.getAttribute(attributeId.getId());
    }

    public RexsAttribute getAttribute(String attributeId) {
        RexsAttribute rexsAttribute = this.attributes.get(attributeId);
        if (rexsAttribute == null) {
            throw new RexsModelAccessException(this, "attribute '" + attributeId + "' not found!");
        }
        return rexsAttribute;
    }

    public RexsUnitId getUnit(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getUnit();
    }

    public boolean hasValue(RexsAttributeId attributeId) {
        return this.hasValue(attributeId.getId());
    }

    public boolean hasValue(String attributeId) {
        if (!this.hasAttribute(attributeId)) {
            return false;
        }
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.hasValue();
    }

    public Object getValue(RexsAttributeId attributeId, RexsValueType type) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getValue(type);
    }

    public String getStringValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getStringValue();
    }

    public boolean getBooleanValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getBooleanValue();
    }

    public int getIntegerValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getIntegerValue();
    }

    public double getDoubleValue(RexsAttributeId attributeId, RexsUnitId unit) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getDoubleValue(unit);
    }

    public String[] getStringArrayValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getStringArrayValue();
    }

    public String[] getEnumArrayValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getEnumArrayValue();
    }

    public Boolean[] getBooleanArrayValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getBooleanArrayValue();
    }

    public Integer[] getIntegerArrayValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getIntegerArrayValue();
    }

    public int[] getIntegerArrayValueUnboxed(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getIntegerArrayValueUnboxed();
    }

    public Double[] getDoubleArrayValue(RexsAttributeId attributeId, RexsUnitId unit) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getDoubleArrayValue(unit);
    }

    public double[] getDoubleArrayValueUnboxed(RexsAttributeId attributeId, RexsUnitId unit) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getDoubleArrayValueUnboxed(unit);
    }

    public String[][] getStringMatrixValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getStringMatrixValue();
    }

    public Boolean[][] getBooleanMatrixValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getBooleanMatrixValue();
    }

    public Integer[][] getIntegerMatrixValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getIntegerMatrixValue();
    }

    public int[][] getIntegerMatrixValueUnboxed(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getIntegerMatrixValueUnboxed();
    }

    public Double[][] getDoubleMatrixValue(RexsAttributeId attributeId, RexsUnitId unit) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getDoubleMatrixValue(unit);
    }

    public double[][] getDoubleMatrixValueUnboxed(RexsAttributeId attributeId, RexsUnitId unit) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getDoubleMatrixValueUnboxed(unit);
    }

    public List<Integer[]> getArrayOfIntegerArraysValue(RexsAttributeId attributeId) {
        RexsAttribute attribute = this.getAttribute(attributeId);
        return attribute.getArrayOfIntegerArraysValue();
    }

    public void addAttribute(RexsAttribute newAttribute) {
        this.attributes.put(newAttribute.getAttributeId().getId(), newAttribute);
    }

    private RexsAttribute createAndAddAttribute(RexsAttributeId attributeId) {
        RexsAttribute attribute = RexsModelObjectFactory.getInstance().createRexsAttribute(attributeId);
        this.addAttribute(attribute);
        return attribute;
    }

    public void addAttribute(RexsAttributeId attributeId, String value) {
        if (value == null) {
            return;
        }
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setStringValue(value);
    }

    public void addAttribute(RexsAttributeId attributeId, Boolean value) {
        if (value == null) {
            return;
        }
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setBooleanValue(value);
    }

    public void addAttribute(RexsAttributeId attributeId, Integer value) {
        if (value == null) {
            return;
        }
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerValue(value);
    }

    public void addAttribute(RexsAttributeId attributeId, Double value) {
        if (value == null) {
            return;
        }
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleValue(value);
    }

    public void addAttribute(RexsAttributeId attributeId, String[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setStringArrayValue(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Boolean[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setBooleanArrayValue(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Integer[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerArrayValue(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, int[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerArrayValue(arrayValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, int[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerArrayValueBase64(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Double[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleArrayValue(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, float[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleArrayValue(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, double[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleArrayValue(arrayValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, float[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleArrayValueBase64(arrayValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, double[] arrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleArrayValueBase64(arrayValues);
    }

    public void addAttribute(RexsAttributeId attributeId, String[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setStringMatrixValue(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Boolean[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setBooleanMatrixValue(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Integer[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerMatrixValue(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, int[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerMatrixValue(matrixValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, int[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setIntegerMatrixValueBase64(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, Double[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleMatrixValue(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, float[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleMatrixValue(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, double[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleMatrixValue(matrixValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, float[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleMatrixValueBase64(matrixValues);
    }

    public void addAttributeBase64(RexsAttributeId attributeId, double[][] matrixValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setDoubleMatrixValueBase64(matrixValues);
    }

    public void addAttribute(RexsAttributeId attributeId, List<Integer[]> arrayOfIntegerArrayValues) {
        RexsAttribute attribute = this.createAndAddAttribute(attributeId);
        attribute.setArrayOfIntegerArraysValue(arrayOfIntegerArrayValues);
    }

    public void changeComponentId(Integer newId) {
        this.id = newId;
    }

    @Override
    public int compareTo(RexsComponent other) {
        return this.getId() - other.getId();
    }

    public void deleteAttribute(RexsAttributeId attributeId) {
        if (this.hasAttribute(attributeId)) {
            this.attributes.remove(attributeId.getId());
        }
    }

    public boolean isOfType(RexsComponentType ... rexsComponentTypes) {
        return this.type.isOneOf(rexsComponentTypes);
    }

    public String toString() {
        if (this.name != null) {
            return this.name + " - " + this.id;
        }
        return String.valueOf(this.id);
    }

    public void setId(Integer newCompId) {
        if (newCompId != null) {
            this.id = newCompId;
        }
    }

    public void setType(RexsComponentType newType) {
        this.type = newType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsComponent)) {
            return false;
        }
        RexsComponent other = (RexsComponent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this_id = this.getId();
        Integer other_id = other.getId();
        return Objects.equals(this_id, other_id);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsComponent;
    }

    public int hashCode() {
        int result = 1;
        Integer _id = this.getId();
        result = result * 59 + (_id == null ? 43 : ((Object)_id).hashCode());
        return result;
    }
}

