/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.model.RexsModelAccessException;
import info.rexs.model.RexsRelationRef;
import info.rexs.schema.constants.RexsRelationRole;
import info.rexs.schema.constants.RexsRelationType;
import info.rexs.schema.constants.standard.RexsStandardRelationRoles;
import info.rexs.schema.constants.standard.RexsStandardRelationTypes;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class RexsRelation {
    private final Integer id;
    private RexsRelationType type;
    private Integer order;
    private List<RexsRelationRef> refs = new ArrayList<RexsRelationRef>();
    private Set<Integer> componentIds = new HashSet<Integer>();

    protected RexsRelation(Integer id, String type, Integer order) {
        this.id = id;
        this.type = RexsRelationType.findByKey(type);
        if (this.type == null) {
            throw new RexsModelAccessException("Invalid RexsRelationType " + type);
        }
        this.order = order;
    }

    public RexsRelation(Integer id, RexsRelationType type, Integer order) {
        this.id = id;
        this.type = type;
        this.order = order;
    }

    public RexsRelation(RexsRelation relation) {
        this.id = relation.id;
        this.type = relation.type;
        this.order = relation.order;
        for (RexsRelationRef reference : relation.getRefs()) {
            RexsRelationRef newReference = new RexsRelationRef(reference);
            this.addRef(newReference);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public RexsRelationType getType() {
        return this.type;
    }

    public Integer getOrder() {
        return this.order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public List<RexsRelationRef> getRefs() {
        return this.refs;
    }

    public void addRef(RexsRelationRef ref) {
        this.refs.add(ref);
        this.componentIds.add(ref.getId());
    }

    public boolean hasComponent(Integer componentId) {
        return this.componentIds.contains(componentId);
    }

    public Integer findComponentIdByRole(RexsRelationRole role) {
        for (RexsRelationRef ref : this.refs) {
            if (!ref.getRole().equals(role)) continue;
            return ref.getId();
        }
        return null;
    }

    public RexsRelationRole findRoleByComponentId(Integer componentId) {
        if (this.hasComponent(componentId)) {
            for (RexsRelationRef ref : this.refs) {
                if (!ref.getId().equals(componentId)) continue;
                return ref.getRole();
            }
        }
        return null;
    }

    public RexsRelationRef findRefByRole(RexsRelationRole role) {
        for (RexsRelationRef ref : this.refs) {
            if (!ref.getRole().equals(role)) continue;
            return ref;
        }
        return null;
    }

    public Integer getMainComponentId() {
        RexsRelationType type = this.getType();
        if (RexsStandardRelationTypes.assembly.equals(type) || RexsStandardRelationTypes.ordered_assembly.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.assembly);
        }
        if (RexsStandardRelationTypes.stage.equals(type) || RexsStandardRelationTypes.stage_gear_data.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.stage);
        }
        if (RexsStandardRelationTypes.flank.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.gear);
        }
        if (RexsStandardRelationTypes.side.equals(type) || RexsStandardRelationTypes.coupling.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.assembly);
        }
        if (RexsStandardRelationTypes.reference.equals(type) || RexsStandardRelationTypes.ordered_reference.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.origin);
        }
        if (RexsStandardRelationTypes.planet_shaft.equals(type) || RexsStandardRelationTypes.central_shaft.equals(type) || RexsStandardRelationTypes.planet_pin.equals(type) || RexsStandardRelationTypes.planet_carrier_shaft.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.planetary_stage);
        }
        if (RexsStandardRelationTypes.connection.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.side_1);
        }
        if (RexsStandardRelationTypes.manufacturing_step.equals(type)) {
            return this.findComponentIdByRole(RexsStandardRelationRoles.workpiece);
        }
        return null;
    }

    public List<Integer> getSubComponentIds() {
        RexsRelationType type = this.getType();
        ArrayList<Integer> subComponentIds = new ArrayList<Integer>();
        if (RexsStandardRelationTypes.assembly.equals(type) || RexsStandardRelationTypes.ordered_assembly.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.part));
        } else if (RexsStandardRelationTypes.stage.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.gear_1));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.gear_2));
        } else if (RexsStandardRelationTypes.stage_gear_data.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.gear));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.stage_gear_data));
        } else if (RexsStandardRelationTypes.flank.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.left));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.right));
        } else if (RexsStandardRelationTypes.side.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.inner_part));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.outer_part));
        } else if (RexsStandardRelationTypes.coupling.equals(type) || RexsStandardRelationTypes.connection.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.side_1));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.side_2));
        } else if (RexsStandardRelationTypes.reference.equals(type) || RexsStandardRelationTypes.ordered_reference.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.referenced));
        } else if (RexsStandardRelationTypes.planet_shaft.equals(type) || RexsStandardRelationTypes.central_shaft.equals(type) || RexsStandardRelationTypes.planet_pin.equals(type) || RexsStandardRelationTypes.planet_carrier_shaft.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.shaft));
        } else if (RexsStandardRelationTypes.manufacturing_step.equals(type)) {
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.tool));
            subComponentIds.add(this.findComponentIdByRole(RexsStandardRelationRoles.manufacturing_settings));
        }
        return subComponentIds;
    }

    public void changeComponentId(Integer oldId, Integer newId) {
        this.componentIds.remove(oldId);
        this.componentIds.add(newId);
        for (RexsRelationRef ref : this.refs) {
            if (!ref.getId().equals(oldId)) continue;
            ref.setId(newId);
        }
    }

    public String toString() {
        String refString = this.refs.stream().map(ref -> ref.getRole().getKey() + ": " + ref.getId()).reduce((a, b) -> a + ", " + b).orElse("");
        return this.type.getKey() + "(" + refString + ")";
    }
}

