/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model;

import info.rexs.model.IRexsModel;
import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.schema.constants.standard.RexsStandardAttributeIds;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RexsSubModel
implements Comparable<RexsSubModel>,
IRexsModel {
    protected Map<Integer, RexsComponent> components = new HashMap<Integer, RexsComponent>();
    private Integer id;
    private boolean isAccumulation = false;

    protected RexsSubModel(Integer id, boolean isAccumulation) {
        this.id = id;
        this.isAccumulation = isAccumulation;
    }

    protected RexsSubModel(Integer id) {
        this(id, false);
    }

    protected RexsSubModel() {
        this(null, true);
    }

    public RexsSubModel(RexsSubModel subModel) {
        this.id = subModel.id;
        this.isAccumulation = subModel.isAccumulation;
        for (RexsComponent component : subModel.getComponents()) {
            RexsComponent rexsComponent = new RexsComponent(component);
            this.addComponent(rexsComponent);
        }
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isAccumulation() {
        return this.isAccumulation;
    }

    @Override
    public List<RexsComponent> getComponents() {
        return this.components.values().stream().collect(Collectors.toList());
    }

    @Override
    public void addComponent(RexsComponent component) {
        this.components.put(component.getId(), component);
    }

    @Override
    public boolean hasComponent(Integer compId) {
        return this.components.containsKey(compId);
    }

    @Override
    public RexsComponent getComponent(Integer compId) {
        return this.components.get(compId);
    }

    public void changeComponentId(Integer oldId, Integer newId) {
        if (this.hasComponent(oldId)) {
            RexsComponent component = this.getComponent(oldId);
            component.changeComponentId(newId);
            this.components.remove(oldId);
            this.components.put(newId, component);
        }
        for (RexsComponent component : this.components.values()) {
            RexsAttribute refCompAttribute;
            if (!component.hasAttribute(RexsStandardAttributeIds.reference_component_for_position) || Integer.valueOf((refCompAttribute = component.getAttribute(RexsStandardAttributeIds.reference_component_for_position)).getStringValue()) != oldId) continue;
            refCompAttribute.setStringValue(String.valueOf(newId));
        }
    }

    @Override
    public int compareTo(RexsSubModel other) {
        if (this.isAccumulation && other.isAccumulation()) {
            return 0;
        }
        if (this.isAccumulation) {
            return 1;
        }
        if (other.isAccumulation()) {
            return -1;
        }
        return this.getId().compareTo(other.getId());
    }

    public boolean equals(Object o) {
        Integer other_id;
        if (o == this) {
            return true;
        }
        if (!(o instanceof RexsSubModel)) {
            return false;
        }
        RexsSubModel other = (RexsSubModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this_id = this.getId();
        if (!Objects.equals(this_id, other_id = other.getId())) {
            return false;
        }
        Boolean this_isAccumulation = this.isAccumulation();
        Boolean other_isAccumulation = other.isAccumulation();
        return Objects.equals(this_isAccumulation, other_isAccumulation);
    }

    protected boolean canEqual(Object other) {
        return other instanceof RexsSubModel;
    }

    public int hashCode() {
        int result = 1;
        Integer _id = this.getId();
        result = result * 59 + (_id == null ? 43 : ((Object)_id).hashCode());
        Boolean _isAccumulation = this.isAccumulation();
        result = result * 59 + (_isAccumulation == null ? 43 : ((Object)_isAccumulation).hashCode());
        return result;
    }
}

