/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.transformer;

import info.rexs.io.json.model.Accumulation;
import info.rexs.io.json.model.Component;
import info.rexs.io.json.model.FloatingPointArrayCoded;
import info.rexs.io.json.model.FloatingPointMatrixCoded;
import info.rexs.io.json.model.JSONModel;
import info.rexs.io.json.model.LoadCase;
import info.rexs.io.json.model.LoadSpectrum;
import info.rexs.io.json.model.Model;
import info.rexs.io.json.model.Ref;
import info.rexs.io.json.model.Relation;
import info.rexs.io.json.model.attributes.ArrayOfIntegerArraysAttribute;
import info.rexs.io.json.model.attributes.Attribute;
import info.rexs.io.json.model.attributes.BooleanArrayAttribute;
import info.rexs.io.json.model.attributes.BooleanAttribute;
import info.rexs.io.json.model.attributes.BooleanMatrixAttribute;
import info.rexs.io.json.model.attributes.DateTimeAttribute;
import info.rexs.io.json.model.attributes.EnumArrayAttribute;
import info.rexs.io.json.model.attributes.EnumAttribute;
import info.rexs.io.json.model.attributes.FileReferenceAttribute;
import info.rexs.io.json.model.attributes.FloatingPointArrayAttribute;
import info.rexs.io.json.model.attributes.FloatingPointArrayCodedAttribute;
import info.rexs.io.json.model.attributes.FloatingPointAttribute;
import info.rexs.io.json.model.attributes.FloatingPointMatrixAttribute;
import info.rexs.io.json.model.attributes.FloatingPointMatrixCodedAttribute;
import info.rexs.io.json.model.attributes.IntegerArrayAttribute;
import info.rexs.io.json.model.attributes.IntegerAttribute;
import info.rexs.io.json.model.attributes.IntegerMatrixAttribute;
import info.rexs.io.json.model.attributes.ReferenceComponentAttribute;
import info.rexs.io.json.model.attributes.StringArrayAttribute;
import info.rexs.io.json.model.attributes.StringAttribute;
import info.rexs.io.json.model.attributes.StringMatrixAttribute;
import info.rexs.model.RexsAttribute;
import info.rexs.model.RexsComponent;
import info.rexs.model.RexsLoadSpectrum;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsModelAccessException;
import info.rexs.model.RexsModelObjectFactory;
import info.rexs.model.RexsRelation;
import info.rexs.model.RexsRelationRef;
import info.rexs.model.RexsSubModel;
import info.rexs.model.transformer.IRexsModelTransformer;
import info.rexs.model.util.DateUtils;
import info.rexs.model.value.AbstractRexsAttributeValue;
import info.rexs.model.value.Base64Type;
import info.rexs.model.value.RexsAttributeValueArray;
import info.rexs.model.value.RexsAttributeValueArrayBase64;
import info.rexs.model.value.RexsAttributeValueArrayOfArrays;
import info.rexs.model.value.RexsAttributeValueMatrix;
import info.rexs.model.value.RexsAttributeValueMatrixBase64;
import info.rexs.model.value.RexsAttributeValueScalar;
import info.rexs.schema.RexsSchemaRegistry;
import info.rexs.schema.constants.RexsValueType;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardAttributeIds;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class RexsModelJsonTransformer
implements IRexsModelTransformer<JSONModel> {
    private RexsVersion version;

    @Override
    public JSONModel transform(RexsModel model) {
        this.version = model.getVersion();
        return new JSONModel().withModel(new Model().withDate(DateUtils.getISO8601Date()).withApplicationId(model.getApplicationId()).withApplicationVersion(model.getApplicationVersion()).withVersion(model.getVersion().equals(RexsVersion.UNKNOWN) ? model.getOriginVersion() : model.getVersion().getModelVersion()).withComponents(this.createComponentsJson(model.getComponents())).withRelations(this.createRelationsJson(model.getRelations())).withLoadSpectrum(this.createLoadSpectrumsJson(model.getLoadSpectrums())));
    }

    @Override
    public RexsModel transform(JSONModel jmodel) {
        Model modelJson = jmodel.getModel();
        RexsModel model = RexsModelObjectFactory.getInstance().createRexsModel(modelJson.getVersion(), modelJson.getApplicationId(), modelJson.getApplicationVersion());
        if (modelJson.getRelations() != null && !modelJson.getRelations().isEmpty()) {
            for (Relation relationJson : modelJson.getRelations()) {
                model.addRelation(this.createRelation(relationJson));
            }
        }
        if (modelJson.getComponents() != null && !modelJson.getComponents().isEmpty()) {
            for (Component componentJson : modelJson.getComponents()) {
                model.addComponent(this.createComponent(componentJson));
            }
        }
        if (modelJson.getLoadSpectrum() != null) {
            model.addLoadSpectrum(this.createLoadSpectrum(modelJson.getLoadSpectrum()));
        }
        return model;
    }

    private List<Relation> createRelationsJson(List<RexsRelation> relations) {
        ArrayList<Relation> relationsJson = new ArrayList<Relation>();
        for (RexsRelation relation : relations) {
            relationsJson.add(this.createRelationJson(relation));
        }
        return relationsJson;
    }

    private Relation createRelationJson(RexsRelation relation) {
        Relation relationJson = new Relation();
        relationJson.setId(relation.getId());
        relationJson.setType(relation.getType().getKey());
        if (relation.getOrder() != null) {
            relationJson.setOrder(relation.getOrder());
        }
        relationJson.getRefs().addAll(this.createRefsJson(relation.getRefs()));
        return relationJson;
    }

    private List<Ref> createRefsJson(Collection<RexsRelationRef> refs) {
        ArrayList<Ref> refsJson = new ArrayList<Ref>();
        for (RexsRelationRef ref : refs) {
            refsJson.add(this.createRefJson(ref));
        }
        return refsJson;
    }

    private Ref createRefJson(RexsRelationRef ref) {
        Ref refJson = new Ref();
        refJson.setId(ref.getId());
        refJson.setHint(ref.getHint());
        refJson.setRole(ref.getRole().getKey());
        return refJson;
    }

    private List<Component> createComponentsJson(List<RexsComponent> components) {
        ArrayList<Component> componentsJson = new ArrayList<Component>();
        List<RexsComponent> sortedComponents = components.stream().sorted(Comparator.comparingInt(RexsComponent::getId)).toList();
        for (RexsComponent component : sortedComponents) {
            componentsJson.add(this.createComponentJson(component));
        }
        return componentsJson;
    }

    private Component createComponentJson(RexsComponent component) {
        Component componentJson = new Component();
        componentJson.setId(component.getId());
        if (component.getType().equals(RexsStandardComponentTypes.UNKNOWN)) {
            componentJson.setType(component.getOriginType());
        } else {
            componentJson.setType(component.getType().getId());
        }
        if (component.getName() != null && !component.getName().isEmpty()) {
            componentJson.setName(component.getName());
        }
        componentJson.getAttributes().addAll(this.createAttributesJson(component.getAttributes()));
        return componentJson;
    }

    private List<Attribute> createAttributesJson(Collection<RexsAttribute> attributes) {
        ArrayList<Attribute> attributesJson = new ArrayList<Attribute>();
        for (RexsAttribute attribute : attributes) {
            attributesJson.addAll(this.createAttributeJson(attribute));
        }
        return attributesJson;
    }

    private List<Attribute> createAttributeJson(RexsAttribute attribute) {
        try {
            Attribute jsonAttribute;
            RexsSchemaRegistry registry = RexsSchemaRegistry.getInstance();
            String attributeId = this.getRexsAttrId(attribute);
            String unit = this.getRexsAttrUnit(attribute);
            AbstractRexsAttributeValue value = attribute.getRawValue();
            if (registry.hasAttributeWithId(this.version, attributeId)) {
                RexsValueType type = registry.getAttributeType(attributeId, this.version);
                switch (type) {
                    case DATE_TIME: {
                        DateTimeAttribute timeAttr = new DateTimeAttribute();
                        timeAttr.setTime(attribute.hasValue() ? attribute.getDateTimeValue().toString() : null);
                        jsonAttribute = timeAttr;
                        break;
                    }
                    case BOOLEAN: {
                        jsonAttribute = new BooleanAttribute().withBoolean(attribute.hasValue() ? Boolean.valueOf(attribute.getBooleanValue()) : null);
                        break;
                    }
                    case ENUM: {
                        jsonAttribute = new EnumAttribute().withEnum(attribute.hasValue() ? attribute.getStringValue() : null);
                        break;
                    }
                    case FILE_REFERENCE: {
                        jsonAttribute = new FileReferenceAttribute().withFileReference(attribute.hasValue() ? attribute.getStringValue() : null);
                        break;
                    }
                    case FLOATING_POINT: {
                        jsonAttribute = new FloatingPointAttribute().withFloatingPoint(attribute.hasValue() ? Double.valueOf(attribute.getDoubleValue(attribute.getUnit())) : null);
                        break;
                    }
                    case INTEGER: {
                        jsonAttribute = new IntegerAttribute().withInteger(attribute.hasValue() ? Integer.valueOf(attribute.getIntegerValue()) : null);
                        break;
                    }
                    case REFERENCE_COMPONENT: {
                        jsonAttribute = new ReferenceComponentAttribute().withReferenceComponent(attribute.hasValue() ? Integer.valueOf(attribute.getIntegerValue()) : null);
                        break;
                    }
                    case STRING: {
                        jsonAttribute = new StringAttribute().withString(attribute.hasValue() ? attribute.getStringValue() : null);
                        break;
                    }
                    case BOOLEAN_ARRAY: {
                        jsonAttribute = new BooleanArrayAttribute().withBooleanArray(attribute.hasValue() ? Arrays.asList(attribute.getBooleanArrayValue()) : null);
                        break;
                    }
                    case ENUM_ARRAY: {
                        jsonAttribute = new EnumArrayAttribute().withEnumArray(attribute.hasValue() ? Arrays.asList(attribute.getStringArrayValue()) : null);
                        break;
                    }
                    case FLOATING_POINT_ARRAY: {
                        if (value instanceof RexsAttributeValueArrayBase64) {
                            RexsAttributeValueArrayBase64 valueBase64 = (RexsAttributeValueArrayBase64)value;
                            Base64Type code = valueBase64.getRawType();
                            FloatingPointArrayCoded fpac = new FloatingPointArrayCoded().withCode(code == null ? null : code.toString()).withValue(valueBase64.getRawValue());
                            jsonAttribute = new FloatingPointArrayCodedAttribute().withFloatingPointArrayCoded(fpac);
                            break;
                        }
                        jsonAttribute = new FloatingPointArrayAttribute().withFloatingPointArray(attribute.hasValue() ? Arrays.asList(attribute.getDoubleArrayValue(attribute.getUnit())) : null);
                        break;
                    }
                    case INTEGER_ARRAY: {
                        jsonAttribute = new IntegerArrayAttribute().withIntegerArray(attribute.hasValue() ? Arrays.asList(attribute.getIntegerArrayValue()) : null);
                        break;
                    }
                    case STRING_ARRAY: {
                        jsonAttribute = new StringArrayAttribute().withStringArray(attribute.hasValue() ? Arrays.asList(attribute.getStringArrayValue()) : null);
                        break;
                    }
                    case BOOLEAN_MATRIX: {
                        jsonAttribute = new BooleanMatrixAttribute().withBooleanMatrix(attribute.hasValue() ? this.get2DArrayAsList(attribute.getBooleanMatrixValue()) : null);
                        break;
                    }
                    case FLOATING_POINT_MATRIX: {
                        if (value instanceof RexsAttributeValueMatrixBase64) {
                            RexsAttributeValueMatrixBase64 valueBase64 = (RexsAttributeValueMatrixBase64)value;
                            Base64Type code = valueBase64.getRawType();
                            FloatingPointMatrixCoded fpac = new FloatingPointMatrixCoded().withCode(code == null ? null : code.toString()).withColumns(valueBase64.getRawCols()).withRows(valueBase64.getRawRows()).withValue(valueBase64.getRawValue());
                            jsonAttribute = new FloatingPointMatrixCodedAttribute().withFloatingPointMatrixCoded(fpac);
                            break;
                        }
                        jsonAttribute = new FloatingPointMatrixAttribute().withFloatingPointMatrix(attribute.hasValue() ? this.get2DArrayAsList(attribute.getDoubleMatrixValue(attribute.getUnit())) : null);
                        break;
                    }
                    case INTEGER_MATRIX: {
                        jsonAttribute = new IntegerMatrixAttribute().withIntegerMatrix(attribute.hasValue() ? this.get2DArrayAsList(attribute.getIntegerMatrixValue()) : null);
                        break;
                    }
                    case STRING_MATRIX: {
                        jsonAttribute = new StringMatrixAttribute().withStringMatrix(attribute.hasValue() ? this.get2DArrayAsList(attribute.getStringMatrixValue()) : null);
                        break;
                    }
                    case ARRAY_OF_INTEGER_ARRAYS: {
                        jsonAttribute = new ArrayOfIntegerArraysAttribute().withArrayOfIntegerArrays(attribute.hasValue() ? this.createListOfIntegerLists(attribute.getArrayOfIntegerArraysValue()) : null);
                        break;
                    }
                    default: {
                        return new ArrayList<Attribute>();
                    }
                }
            } else {
                if (value == null) {
                    return new ArrayList<Attribute>();
                }
                jsonAttribute = this.createAttributeJsonCustom(value, unit);
            }
            return Collections.singletonList(jsonAttribute.withId(attributeId).withUnit(unit));
        }
        catch (Exception e) {
            return new ArrayList<Attribute>();
        }
    }

    private Attribute createAttributeJsonCustom(AbstractRexsAttributeValue value, String unit) {
        if (value instanceof RexsAttributeValueScalar) {
            String valueString = ((RexsAttributeValueScalar)value).getRawValue();
            if (valueString == null || valueString.isEmpty()) {
                return new StringAttribute().withString(valueString);
            }
            if (valueString.equals("true") || valueString.equals("false")) {
                return new BooleanAttribute().withBoolean(Boolean.valueOf(valueString));
            }
            if (!unit.equals(RexsStandardUnitIds.none.getId())) {
                return new FloatingPointAttribute().withFloatingPoint(Double.valueOf(valueString));
            }
            try {
                return new IntegerAttribute().withInteger(Integer.valueOf(valueString));
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new FloatingPointAttribute().withFloatingPoint(Double.valueOf(valueString));
                }
                catch (NumberFormatException numberFormatException2) {
                    return new StringAttribute().withString(valueString);
                }
            }
        }
        if (value instanceof RexsAttributeValueArray) {
            RexsAttributeValueArray arrayValue = (RexsAttributeValueArray)value;
            List<String> valueString = arrayValue.getRawValue();
            if (valueString == null || valueString.isEmpty() || valueString.get(0) == null || valueString.get(0).isEmpty()) {
                return new StringArrayAttribute().withStringArray(valueString);
            }
            if (valueString.get(0).equals("true") || valueString.get(0).equals("false")) {
                return new BooleanArrayAttribute().withBooleanArray(valueString.stream().map(Boolean::valueOf).toList());
            }
            if (!unit.equals(RexsStandardUnitIds.none.getId())) {
                return new FloatingPointArrayAttribute().withFloatingPointArray(valueString.stream().map(Double::valueOf).toList());
            }
            try {
                return new IntegerArrayAttribute().withIntegerArray(valueString.stream().map(Integer::valueOf).toList());
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    return new FloatingPointArrayAttribute().withFloatingPointArray(valueString.stream().map(Double::valueOf).toList());
                }
                catch (NumberFormatException numberFormatException3) {
                    return new StringArrayAttribute().withStringArray(valueString);
                }
            }
        }
        if (value instanceof RexsAttributeValueArrayBase64) {
            RexsAttributeValueArrayBase64 valueBase64 = (RexsAttributeValueArrayBase64)value;
            Base64Type code = valueBase64.getRawType();
            FloatingPointArrayCoded fpac2 = new FloatingPointArrayCoded().withCode(code == null ? null : code.toString()).withValue(valueBase64.getRawValue());
            return new FloatingPointArrayCodedAttribute().withFloatingPointArrayCoded(fpac2);
        }
        if (value instanceof RexsAttributeValueMatrix) {
            RexsAttributeValueMatrix matrixValue = (RexsAttributeValueMatrix)value;
            List<List<String>> valueString = matrixValue.getRawValue();
            if (valueString == null || valueString.isEmpty() || valueString.get(0) == null || valueString.get(0).isEmpty() || valueString.get(0).get(0) == null || valueString.get(0).get(0).isEmpty()) {
                return new StringMatrixAttribute().withStringMatrix(valueString);
            }
            if (valueString.get(0).get(0).equals("true") || valueString.get(0).get(0).equals("false")) {
                return new BooleanMatrixAttribute().withBooleanMatrix(valueString.stream().map(list -> list.stream().map(Boolean::valueOf).toList()).toList());
            }
            if (!unit.equals(RexsStandardUnitIds.none.getId())) {
                return new FloatingPointMatrixAttribute().withFloatingPointMatrix(valueString.stream().map(list -> list.stream().map(Double::valueOf).toList()).toList());
            }
            try {
                return new IntegerMatrixAttribute().withIntegerMatrix(valueString.stream().map(list -> list.stream().map(Integer::valueOf).toList()).toList());
            }
            catch (NumberFormatException fpac2) {
                try {
                    return new BooleanMatrixAttribute().withBooleanMatrix(valueString.stream().map(list -> list.stream().map(Boolean::valueOf).toList()).toList());
                }
                catch (NumberFormatException fpac2) {
                    return new StringMatrixAttribute().withStringMatrix(valueString);
                }
            }
        }
        if (value instanceof RexsAttributeValueMatrixBase64) {
            RexsAttributeValueMatrixBase64 valueBase64 = (RexsAttributeValueMatrixBase64)value;
            Base64Type code = valueBase64.getRawType();
            FloatingPointMatrixCoded fpac = new FloatingPointMatrixCoded().withCode(code == null ? null : code.toString()).withColumns(valueBase64.getRawCols()).withRows(valueBase64.getRawRows()).withValue(valueBase64.getRawValue());
            return new FloatingPointMatrixCodedAttribute().withFloatingPointMatrixCoded(fpac);
        }
        if (value instanceof RexsAttributeValueArrayOfArrays) {
            List<Integer[]> valueString = value.getValueArrayOfIntegerArrays();
            return new ArrayOfIntegerArraysAttribute().withArrayOfIntegerArrays(valueString.stream().map(Arrays::asList).toList());
        }
        throw new RexsModelAccessException("unkown value type: " + String.valueOf(value));
    }

    private List<List<Integer>> createListOfIntegerLists(List<Integer[]> listOfIntegerArraysValue) {
        ArrayList<List<Integer>> listOfLists = new ArrayList<List<Integer>>();
        for (Integer[] array : listOfIntegerArraysValue) {
            listOfLists.add(Arrays.asList(array));
        }
        return listOfLists;
    }

    private String getRexsAttrId(RexsAttribute attribute) {
        if (attribute.getAttributeId().equals(RexsStandardAttributeIds.UNKNOWN)) {
            return attribute.getOriginAttributeId();
        }
        return attribute.getAttributeId().getId();
    }

    private String getRexsAttrUnit(RexsAttribute attribute) {
        if (attribute.getUnit().equals(RexsStandardUnitIds.UNKNOWN)) {
            return attribute.getOriginUnit();
        }
        return attribute.getUnit().getId();
    }

    private <T> List<List<T>> get2DArrayAsList(T[][] arr) {
        ArrayList<List<T>> twoDList = new ArrayList<List<T>>();
        for (T[] list : arr) {
            twoDList.add(Arrays.asList(list));
        }
        return twoDList;
    }

    private LoadSpectrum createLoadSpectrumsJson(List<RexsLoadSpectrum> loadSpectrums) {
        if (loadSpectrums == null || loadSpectrums.isEmpty()) {
            return null;
        }
        RexsLoadSpectrum loadSpectrum = loadSpectrums.get(0);
        LoadSpectrum loadSpectrumJson = new LoadSpectrum();
        loadSpectrumJson.setId(loadSpectrum.getId());
        loadSpectrumJson.setLoadCases(this.createLoadCasesJson(loadSpectrum.getLoadCases()));
        loadSpectrumJson.setAccumulation(this.createAccumulationJson(loadSpectrum.getAccumulation()));
        return loadSpectrumJson;
    }

    private List<LoadCase> createLoadCasesJson(Collection<RexsSubModel> loadCases) {
        if (loadCases == null || loadCases.isEmpty()) {
            return new ArrayList<LoadCase>();
        }
        ArrayList<LoadCase> loadCasesJson = new ArrayList<LoadCase>();
        for (RexsSubModel loadCase : loadCases) {
            LoadCase loadCaseJson = new LoadCase();
            loadCaseJson.setId(loadCase.getId());
            loadCaseJson.setComponents(this.createComponentsJson(loadCase.getComponents()));
            loadCasesJson.add(loadCaseJson);
        }
        return loadCasesJson;
    }

    private Accumulation createAccumulationJson(RexsSubModel accumulation) {
        if (accumulation == null) {
            return null;
        }
        List<RexsComponent> components = accumulation.getComponents();
        if (components == null || components.isEmpty()) {
            return null;
        }
        Accumulation accumulationJson = new Accumulation();
        accumulationJson.setComponents(this.createComponentsJson(accumulation.getComponents()));
        return accumulationJson;
    }

    private RexsRelation createRelation(Relation relationJson) {
        RexsRelation relation = RexsModelObjectFactory.getInstance().createRexsRelation(relationJson.getId(), relationJson.getType(), relationJson.getOrder());
        if (relationJson.getRefs() != null) {
            for (Ref refJson : relationJson.getRefs()) {
                RexsRelationRef ref = RexsModelObjectFactory.getInstance().createRexsRelationRef(refJson.getId(), refJson.getRole(), refJson.getHint());
                relation.addRef(ref);
            }
        }
        return relation;
    }

    private RexsComponent createComponent(Component componentJson) {
        RexsComponent component = RexsModelObjectFactory.getInstance().createRexsComponent(componentJson.getId(), componentJson.getType(), componentJson.getName());
        if (componentJson.getAttributes() != null) {
            for (Attribute attributeJson : componentJson.getAttributes()) {
                component.addAttribute(this.createAttribute(attributeJson));
            }
        }
        return component;
    }

    private RexsAttribute createAttribute(Attribute attributeJson) {
        String unit = attributeJson.getUnit();
        RexsAttribute attribute = unit != null ? RexsModelObjectFactory.getInstance().createRexsAttribute(attributeJson.getId(), unit) : RexsModelObjectFactory.getInstance().createRexsAttribute(attributeJson.getId());
        attribute.setRawValue(this.createAttributeValue(attributeJson));
        return attribute;
    }

    private AbstractRexsAttributeValue createAttributeValue(Attribute attributeJson) {
        if (attributeJson instanceof DateTimeAttribute) {
            return new RexsAttributeValueScalar(((DateTimeAttribute)attributeJson).getTime());
        }
        if (attributeJson instanceof StringAttribute) {
            return new RexsAttributeValueScalar(((StringAttribute)attributeJson).getString());
        }
        if (attributeJson instanceof FloatingPointAttribute) {
            return new RexsAttributeValueScalar(((FloatingPointAttribute)attributeJson).getFloatingPoint().toString());
        }
        if (attributeJson instanceof IntegerAttribute) {
            return new RexsAttributeValueScalar(((IntegerAttribute)attributeJson).getInteger().toString());
        }
        if (attributeJson instanceof BooleanAttribute) {
            return new RexsAttributeValueScalar(((BooleanAttribute)attributeJson).getBoolean().toString());
        }
        if (attributeJson instanceof EnumAttribute) {
            return new RexsAttributeValueScalar(((EnumAttribute)attributeJson).getEnum());
        }
        if (attributeJson instanceof FileReferenceAttribute) {
            return new RexsAttributeValueScalar(((FileReferenceAttribute)attributeJson).getFileReference());
        }
        if (attributeJson instanceof ReferenceComponentAttribute) {
            return new RexsAttributeValueScalar(((ReferenceComponentAttribute)attributeJson).getReferenceComponent().toString());
        }
        if (attributeJson instanceof StringArrayAttribute) {
            return new RexsAttributeValueArray(((StringArrayAttribute)attributeJson).getStringArray());
        }
        if (attributeJson instanceof IntegerArrayAttribute) {
            RexsAttributeValueArray array = new RexsAttributeValueArray();
            List<Integer> intList = ((IntegerArrayAttribute)attributeJson).getIntegerArray();
            array.setValueIntegerArray(intList.toArray(new Integer[intList.size()]));
            return array;
        }
        if (attributeJson instanceof FloatingPointArrayAttribute) {
            RexsAttributeValueArray array = new RexsAttributeValueArray();
            List<Double> intList = ((FloatingPointArrayAttribute)attributeJson).getFloatingPointArray();
            array.setValueDoubleArray(intList.toArray(new Double[intList.size()]));
            return array;
        }
        if (attributeJson instanceof FloatingPointArrayCodedAttribute) {
            FloatingPointArrayCoded arrayCoded = ((FloatingPointArrayCodedAttribute)attributeJson).getFloatingPointArrayCoded();
            return new RexsAttributeValueArrayBase64(arrayCoded.getValue(), Base64Type.valueOf(arrayCoded.getCode()));
        }
        if (attributeJson instanceof BooleanArrayAttribute) {
            RexsAttributeValueArray array = new RexsAttributeValueArray();
            List<Boolean> intList = ((BooleanArrayAttribute)attributeJson).getBooleanArray();
            array.setValueBooleanArray(intList.toArray(new Boolean[intList.size()]));
            return array;
        }
        if (attributeJson instanceof StringMatrixAttribute) {
            List<List<String>> jsonValue = ((StringMatrixAttribute)attributeJson).getStringMatrix();
            return new RexsAttributeValueMatrix(jsonValue);
        }
        if (attributeJson instanceof IntegerMatrixAttribute) {
            List<List<Integer>> jsonValue = ((IntegerMatrixAttribute)attributeJson).getIntegerMatrix();
            ArrayList<List<String>> stringValue = new ArrayList<List<String>>();
            for (List<Integer> list : jsonValue) {
                stringValue.add(list.stream().map(Object::toString).toList());
            }
            return new RexsAttributeValueMatrix(stringValue);
        }
        if (attributeJson instanceof FloatingPointMatrixAttribute) {
            List<List<Double>> jsonValue = ((FloatingPointMatrixAttribute)attributeJson).getFloatingPointMatrix();
            ArrayList<List<String>> stringValue = new ArrayList<List<String>>();
            for (List<Double> list : jsonValue) {
                stringValue.add(list.stream().map(Object::toString).toList());
            }
            return new RexsAttributeValueMatrix(stringValue);
        }
        if (attributeJson instanceof FloatingPointMatrixCodedAttribute) {
            FloatingPointMatrixCoded matrixCoded = ((FloatingPointMatrixCodedAttribute)attributeJson).getFloatingPointMatrixCoded();
            return new RexsAttributeValueMatrixBase64(matrixCoded.getValue(), Base64Type.valueOf(matrixCoded.getCode()), matrixCoded.getRows(), matrixCoded.getColumns());
        }
        if (attributeJson instanceof BooleanMatrixAttribute) {
            List<List<Boolean>> jsonValue = ((BooleanMatrixAttribute)attributeJson).getBooleanMatrix();
            ArrayList<List<String>> stringValue = new ArrayList<List<String>>();
            for (List<Boolean> list : jsonValue) {
                stringValue.add(list.stream().map(Object::toString).toList());
            }
            return new RexsAttributeValueMatrix(stringValue);
        }
        if (attributeJson instanceof ArrayOfIntegerArraysAttribute) {
            List<List<Integer>> jsonValue = ((ArrayOfIntegerArraysAttribute)attributeJson).getArrayOfIntegerArrays();
            ArrayList<List<String>> stringValue = new ArrayList<List<String>>();
            for (List<Integer> list : jsonValue) {
                stringValue.add(list.stream().map(Object::toString).toList());
            }
            return new RexsAttributeValueMatrix(stringValue);
        }
        return null;
    }

    private RexsLoadSpectrum createLoadSpectrum(LoadSpectrum loadSpectrumJson) {
        RexsLoadSpectrum loadSpectrum = RexsModelObjectFactory.getInstance().createRexsLoadSpectrum(loadSpectrumJson.getId());
        if (loadSpectrumJson.getLoadCases() != null) {
            for (LoadCase loadCaseJson : loadSpectrumJson.getLoadCases()) {
                loadSpectrum.addLoadCase(this.createLoadCase(loadCaseJson));
            }
        }
        if (loadSpectrumJson.getAccumulation() != null) {
            loadSpectrum.setAccumulation(this.createAccumulation(loadSpectrumJson.getAccumulation()));
        }
        return loadSpectrum;
    }

    private RexsSubModel createLoadCase(LoadCase loadCaseJson) {
        RexsSubModel loadCase = RexsModelObjectFactory.getInstance().createRexsSubModel(loadCaseJson.getId());
        if (loadCaseJson.getComponents() != null) {
            for (Component componentJson : loadCaseJson.getComponents()) {
                loadCase.addComponent(this.createComponent(componentJson));
            }
        }
        return loadCase;
    }

    private RexsSubModel createAccumulation(Accumulation accumulationJson) {
        RexsSubModel accumulation = RexsModelObjectFactory.getInstance().createRexsSubModel();
        if (accumulationJson.getComponents() != null) {
            for (Component componentJson : accumulationJson.getComponents()) {
                accumulation.addComponent(this.createComponent(componentJson));
            }
        }
        return accumulation;
    }
}

