/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.model.util;

import java.util.Arrays;
import java.util.stream.IntStream;

public class JavaDatatypeUtils {
    private JavaDatatypeUtils() {
    }

    public static Integer[] boxIntArray(int[] array) {
        return (Integer[])Arrays.stream(array).boxed().toArray(Integer[]::new);
    }

    public static Double[] boxFloatArray(float[] array) {
        return (Double[])IntStream.range(0, array.length).mapToDouble(i -> array[i]).boxed().toArray(Double[]::new);
    }

    public static Double[] boxDoubleArray(double[] array) {
        return (Double[])Arrays.stream(array).boxed().toArray(Double[]::new);
    }

    public static Integer[][] boxIntMatrix(int[][] matrix) {
        int colLength = 0;
        for (int i = 0; i < matrix.length; ++i) {
            colLength += matrix[i].length;
        }
        Integer[][] boxedMatrix = new Integer[matrix.length][colLength];
        for (int i = 0; i < matrix.length; ++i) {
            boxedMatrix[i] = JavaDatatypeUtils.boxIntArray(matrix[i]);
        }
        return boxedMatrix;
    }

    public static Double[][] boxFloatMatrix(float[][] matrix) {
        int colLength = 0;
        for (int i = 0; i < matrix.length; ++i) {
            colLength += matrix[i].length;
        }
        Double[][] boxedMatrix = new Double[matrix.length][colLength];
        for (int i = 0; i < matrix.length; ++i) {
            boxedMatrix[i] = JavaDatatypeUtils.boxFloatArray(matrix[i]);
        }
        return boxedMatrix;
    }

    public static Double[][] boxDoubleMatrix(double[][] matrix) {
        int colLength = 0;
        for (int i = 0; i < matrix.length; ++i) {
            colLength += matrix[i].length;
        }
        Double[][] boxedMatrix = new Double[matrix.length][colLength];
        for (int i = 0; i < matrix.length; ++i) {
            boxedMatrix[i] = JavaDatatypeUtils.boxDoubleArray(matrix[i]);
        }
        return boxedMatrix;
    }
}

