/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders.changelog;

import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.changelog.ChangelogFile;
import info.rexs.upgrade.upgraders.changelog.jaxb.RexsChangelog;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.Unmarshaller;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public class ChangelogResolver {
    private static ChangelogResolver instance = null;
    private Map<ChangelogFile, RexsChangelog> changelogFileCache = new HashMap<ChangelogFile, RexsChangelog>();

    private ChangelogResolver() {
    }

    public static synchronized ChangelogResolver getInstance() {
        if (instance == null) {
            instance = new ChangelogResolver();
        }
        return instance;
    }

    public RexsChangelog resolve(ChangelogFile changelogFile) throws RexsUpgradeException {
        if (changelogFile == null) {
            return null;
        }
        if (this.changelogFileCache.containsKey(changelogFile)) {
            return this.changelogFileCache.get(changelogFile);
        }
        RexsChangelog changelog = null;
        try (InputStream input = changelogFile.openInputStream();){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{RexsChangelog.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            changelog = (RexsChangelog)unmarshaller.unmarshal(input);
        }
        catch (Exception ex) {
            throw new RexsUpgradeException(String.format("could not load rexs changelog for version %s to version %s", changelogFile.getFromVersion().getModelVersion(), changelogFile.getToVersion().getModelVersion()), ex);
        }
        this.changelogFileCache.put(changelogFile, changelog);
        return changelog;
    }
}

