/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.validation;

import info.rexs.model.RexsComponent;
import info.rexs.model.RexsModel;
import info.rexs.model.RexsRelation;
import info.rexs.schema.IRexsSchemaRegistry;
import info.rexs.schema.constants.RexsComponentType;
import info.rexs.schema.constants.standard.RexsStandardComponentTypes;
import info.rexs.schema.constants.standard.RexsStandardRelationRoles;
import info.rexs.schema.constants.standard.RexsStandardRelationTypes;
import info.rexs.schema.jaxb.AllowedCombinationRole;
import info.rexs.validation.IRexsRelationValidator;
import info.rexs.validation.RexsModellingGuidelineQuasistaticRelationValidator;
import info.rexs.validation.RexsStandardModelValidator;
import info.rexs.validation.RexsValidationResult;
import info.rexs.validation.RexsValidationResultMessageKey;
import java.util.HashSet;
import java.util.List;

public class RexsModellingGuidelineQuasistaticModelValidator
extends RexsStandardModelValidator {
    public RexsModellingGuidelineQuasistaticModelValidator() {
    }

    public RexsModellingGuidelineQuasistaticModelValidator(IRexsSchemaRegistry rexsSchemaRegistry) {
        super(rexsSchemaRegistry);
    }

    @Override
    public RexsValidationResult validate(RexsModel rexsModel) {
        RexsValidationResult validationResult = super.validate(rexsModel);
        validationResult.add(this.checkIfUniqueGearUnitIsPresent(rexsModel));
        validationResult.add(this.checkIfComponentWithoutRelationIsPresent(rexsModel));
        validationResult.add(this.checkShaftSections(rexsModel));
        validationResult.add(this.checkGears(rexsModel));
        validationResult.add(this.checkStages(rexsModel));
        validationResult.add(this.checkSideReleations(rexsModel));
        validationResult.add(this.checkPlanetCarrier(rexsModel));
        return validationResult;
    }

    private RexsValidationResult checkSideReleations(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        List<RexsRelation> sideRelations = rexsModel.getRelationsOfType(RexsStandardRelationTypes.side);
        if (this.rexsSchemaRegistry.hasRelationTypes(this.rexsVersion)) {
            List<List<AllowedCombinationRole>> listOfAllowedCombinationsSideRelation = this.rexsSchemaRegistry.getAllowedCombinationsForRelation(this.rexsVersion, RexsStandardRelationTypes.side);
            HashSet<RexsComponentType> mainComponentTypesForSideRelation = new HashSet<RexsComponentType>();
            block0: for (List<AllowedCombinationRole> allowedCombination : listOfAllowedCombinationsSideRelation) {
                for (AllowedCombinationRole combination : allowedCombination) {
                    if (!combination.getRoleId().equals(RexsStandardRelationRoles.assembly.getKey())) continue;
                    mainComponentTypesForSideRelation.add(RexsComponentType.findById(combination.getComponentId()));
                    continue block0;
                }
            }
            for (RexsComponentType mainType : mainComponentTypesForSideRelation) {
                for (RexsComponent mainComponent : rexsModel.getComponentsOfType(mainType)) {
                    if (!sideRelations.stream().noneMatch(r -> r.hasComponent(mainComponent.getId()))) continue;
                    validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_COMPONENT_REQUIRES_SIDE_RELATION, mainComponent.toString(), mainComponent.getType().getId());
                }
            }
        }
        for (RexsComponent shaft : rexsModel.getComponentsOfType(RexsStandardComponentTypes.shaft)) {
            if (!sideRelations.stream().noneMatch(r -> r.hasComponent(shaft.getId()))) continue;
            validationResult.addWarning(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_SHAFT_WITHOUT_SIDE_RELATION, shaft.toString());
        }
        return validationResult;
    }

    private RexsValidationResult checkPlanetCarrier(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        for (RexsComponent planetaryStage : rexsModel.getComponentsOfType(RexsStandardComponentTypes.planetary_stage)) {
            try {
                List<RexsRelation> sideRelations;
                List<RexsComponent> sidePlates;
                RexsComponent carrier = rexsModel.getSubComponentsWithType(planetaryStage.getId(), RexsStandardComponentTypes.planet_carrier).get(0);
                List<RexsComponent> shaftsInCarrier = rexsModel.getSubComponentsWithType(carrier.getId(), RexsStandardComponentTypes.shaft);
                List<RexsRelation> relationsOfPlanetaryStage = rexsModel.getRelationsOfMainComp(planetaryStage.getId());
                List<Integer> carrierShaftIds = relationsOfPlanetaryStage.stream().filter(r -> r.getType() == RexsStandardRelationTypes.planet_carrier_shaft).map(r -> r.findComponentIdByRole(RexsStandardRelationRoles.shaft)).toList();
                List<Integer> pinShaftIds = relationsOfPlanetaryStage.stream().filter(r -> r.getType() == RexsStandardRelationTypes.planet_pin).map(r -> r.findComponentIdByRole(RexsStandardRelationRoles.shaft)).toList();
                if (carrierShaftIds.isEmpty()) {
                    validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_PLANETARY_STAGE_MISSING_PLANET_CARRIER_SHAFT, planetaryStage.toString());
                }
                if (shaftsInCarrier.stream().noneMatch(s -> carrierShaftIds.contains(s.getId()))) {
                    validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_PLANETARY_CARRIER_MISSING_PLANET_CARRIER_SHAFT, planetaryStage.toString());
                }
                if ((sidePlates = rexsModel.getSubComponentsWithType(carrier.getId(), RexsStandardComponentTypes.side_plate)).isEmpty()) {
                    validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_PLANETARY_CARRIER_MISSING_SIDE_PLATE, planetaryStage.toString());
                } else {
                    for (RexsComponent sidePlate : sidePlates) {
                        sideRelations = rexsModel.getRelations(RexsStandardRelationTypes.side, RexsStandardRelationRoles.outer_part, sidePlate.getId());
                        if (this.atLeastOneIdIsContainedInRelations(carrierShaftIds, sideRelations)) continue;
                        validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_SIDE_PLATE_MISSING_CARRIER_SHAFT_COUPLING, sidePlate.toString());
                    }
                }
                for (Integer pinId : pinShaftIds) {
                    sideRelations = rexsModel.getRelations(RexsStandardRelationTypes.side, RexsStandardRelationRoles.inner_part, pinId);
                    if (this.atLeastOneIdIsContainedInRelations(sidePlates.stream().map(RexsComponent::getId).toList(), sideRelations)) continue;
                    validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_SIDE_PLATE_MISSING_PIN_COUPLING, rexsModel.getComponent(pinId).toString());
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            }
        }
        return validationResult;
    }

    private boolean atLeastOneIdIsContainedInRelations(List<Integer> componentIds, List<RexsRelation> relations) {
        for (Integer componentId : componentIds) {
            if (!relations.stream().anyMatch(r -> r.hasComponent(componentId))) continue;
            return true;
        }
        return false;
    }

    private RexsValidationResult checkGears(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        List<RexsComponent> gears = rexsModel.getComponentsOfType(RexsStandardComponentTypes.cylindrical_gear);
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.ring_gear));
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.bevel_gear));
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.worm_gear));
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.worm_wheel));
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.involute_spline_gear_shaft));
        gears.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.involute_spline_gear_hub));
        for (RexsComponent gear : gears) {
            if (!rexsModel.getStagesOfGear(gear).isEmpty()) continue;
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_INCONSISTENT_GEAR, gear.toString());
        }
        return validationResult;
    }

    private RexsValidationResult checkStages(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        List<RexsComponent> stages = rexsModel.getComponentsOfType(RexsStandardComponentTypes.cylindrical_stage);
        stages.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.bevel_stage));
        stages.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.worm_stage));
        stages.addAll(rexsModel.getComponentsOfType(RexsStandardComponentTypes.involute_spline_connection));
        for (RexsComponent stage : stages) {
            RexsComponent gear1 = rexsModel.getGear1OfStage(stage.getId());
            RexsComponent gear2 = rexsModel.getGear2OfStage(stage.getId());
            if (gear1 != null && gear2 != null && gear1.getId() != gear2.getId()) continue;
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_INCONSISTENT_STAGE, stage.toString());
        }
        return validationResult;
    }

    private RexsValidationResult checkShaftSections(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        for (RexsComponent shaft : rexsModel.getComponentsOfType(RexsStandardComponentTypes.shaft)) {
            if (!rexsModel.getSubComponentsWithType(shaft.getId(), RexsStandardComponentTypes.shaft_section).isEmpty()) continue;
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_SHAFT_WITHOUT_SHAFT_SECTION, shaft.toString());
        }
        return validationResult;
    }

    private RexsValidationResult checkIfComponentWithoutRelationIsPresent(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        List<RexsRelation> relations = rexsModel.getRelations();
        for (RexsComponent component : rexsModel.getComponents()) {
            if (!relations.stream().noneMatch(r -> r.hasComponent(component.getId()))) continue;
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_COMPONENT_WITHOUT_RELATION, component.toString());
        }
        return validationResult;
    }

    private RexsValidationResult checkIfUniqueGearUnitIsPresent(RexsModel rexsModel) {
        RexsValidationResult validationResult = new RexsValidationResult();
        if (rexsModel.getComponentsOfType(RexsStandardComponentTypes.gear_unit).size() != 1) {
            validationResult.addError(RexsValidationResultMessageKey.GUIDELINE_QUASISTATIC_INCONSISTENT_GEAR_UNIT, new String[0]);
        }
        return validationResult;
    }

    @Override
    public IRexsRelationValidator createRelationValidator() {
        if (this.rexsVersion == null) {
            return super.createRelationValidator();
        }
        return new RexsModellingGuidelineQuasistaticRelationValidator(this.rexsVersion, this.rexsSchemaRegistry);
    }
}

