/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.RexsFileReader;
import info.rexs.io.RexsIoException;
import info.rexs.io.xml.RexsXmlFileWriter;
import info.rexs.model.RexsModel;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.RexsUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RexsFileUpgrader {
    private final Path pathToRexsInputFile;
    private final Path pathToRexsOutputFile;

    public RexsFileUpgrader(Path pathToRexsInputFile, Path pathToRexsOutputFile) {
        this.pathToRexsInputFile = pathToRexsInputFile;
        this.pathToRexsOutputFile = pathToRexsOutputFile;
    }

    public RexsFileUpgrader(File rexsInputFile, File rexsOutputFile) {
        this(rexsInputFile.toPath(), rexsOutputFile.toPath());
    }

    public RexsFileUpgrader(String rexsInputFilePath, String rexsOutputFilePath) {
        this(Paths.get(rexsInputFilePath, new String[0]), Paths.get(rexsOutputFilePath, new String[0]));
    }

    public void upgrade() throws RexsUpgradeException, RexsIoException {
        RexsFileReader rexsFileReader = new RexsFileReader(this.pathToRexsInputFile);
        RexsModel rexsModel = rexsFileReader.read();
        RexsUpgrader rexsUpgrader = new RexsUpgrader(rexsModel);
        ModelUpgraderResult result = rexsUpgrader.upgrade();
        RexsXmlFileWriter rexsFileWriter = new RexsXmlFileWriter(this.pathToRexsOutputFile);
        rexsFileWriter.write(result.getModel());
    }
}

