/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.AbstractRexsFileWriter;
import info.rexs.io.RexsIoException;
import info.rexs.io.RexsIoFormat;
import info.rexs.model.RexsModel;
import java.io.File;
import java.nio.file.Path;

public class RexsFileWriter
extends AbstractRexsFileWriter {
    public RexsFileWriter(Path pathToRexsOutputFile) {
        super(pathToRexsOutputFile);
    }

    public RexsFileWriter(File rexsOutputFile) {
        super(rexsOutputFile);
    }

    public RexsFileWriter(String rexsOutputFilePath) {
        super(rexsOutputFilePath);
    }

    @Override
    public void write(RexsModel model) throws RexsIoException {
        this.validateOutputFile();
        RexsIoFormat format = RexsIoFormat.findFormatByFilename(this.pathToRexsOutputFile.getFileName().toString());
        if (format == null) {
            throw new RexsIoException("rexs file " + String.valueOf(this.pathToRexsOutputFile) + " has unknown filename ending");
        }
        AbstractRexsFileWriter writer = format.createNewFileWriter(this.pathToRexsOutputFile);
        writer.write(model);
    }
}

