/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io;

import info.rexs.io.AbstractRexsFileReader;
import info.rexs.io.AbstractRexsFileWriter;
import info.rexs.io.Resource;
import info.rexs.io.json.RexsJsonFileReader;
import info.rexs.io.json.RexsJsonFileWriter;
import info.rexs.io.xml.RexsXmlFileReader;
import info.rexs.io.xml.RexsXmlFileWriter;
import info.rexs.io.zip.RexsZipFileReader;
import info.rexs.io.zip.RexsZipFileWriter;
import java.nio.file.Path;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum RexsIoFormat {
    JSON(new String[]{"rexsj", "rexs.json"}){

        @Override
        public AbstractRexsFileWriter createNewFileWriter(Path pathToRexsOutputFile) {
            return new RexsJsonFileWriter(pathToRexsOutputFile);
        }

        @Override
        public AbstractRexsFileReader createNewFileReader(Resource rexsInputFileResource) {
            return new RexsJsonFileReader(rexsInputFileResource);
        }
    }
    ,
    XML(new String[]{"rexs", "rexs.xml"}){

        @Override
        public AbstractRexsFileWriter createNewFileWriter(Path pathToRexsOutputFile) {
            return new RexsXmlFileWriter(pathToRexsOutputFile);
        }

        @Override
        public AbstractRexsFileReader createNewFileReader(Resource rexsInputFileResource) {
            return new RexsXmlFileReader(rexsInputFileResource);
        }
    }
    ,
    ZIP(new String[]{"rexsz", "rexs.zip"}){

        @Override
        public AbstractRexsFileWriter createNewFileWriter(Path pathToRexsOutputFile) {
            return new RexsZipFileWriter(pathToRexsOutputFile);
        }

        @Override
        public AbstractRexsFileReader createNewFileReader(Resource rexsInputFileResource) {
            return new RexsZipFileReader(rexsInputFileResource);
        }
    };

    private final String[] endings;

    private RexsIoFormat(String ... endings) {
        this.endings = endings;
    }

    public String[] getEndings() {
        return this.endings;
    }

    public boolean hasEnding(String filename) {
        if (filename == null) {
            return false;
        }
        for (String ending : this.endings) {
            if (!filename.toLowerCase().endsWith(ending)) continue;
            return true;
        }
        return false;
    }

    public AbstractRexsFileWriter createNewFileWriter(Path pathToRexsOutputFile) {
        throw new RuntimeException("writer not implemented for format");
    }

    public AbstractRexsFileReader createNewFileReader(Resource rexsInputFileResource) {
        throw new RuntimeException("reader not implemented for format");
    }

    public static RexsIoFormat findFormatByFilename(String filename) {
        if (filename == null) {
            return null;
        }
        for (RexsIoFormat format : RexsIoFormat.values()) {
            if (!format.hasEnding(filename)) continue;
            return format;
        }
        return null;
    }
}

