/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.io.xml;

import info.rexs.io.AbstractRexsFileWriter;
import info.rexs.io.RexsIoException;
import info.rexs.model.RexsModel;
import info.rexs.model.jaxb.Accumulation;
import info.rexs.model.jaxb.Attribute;
import info.rexs.model.jaxb.Component;
import info.rexs.model.jaxb.LoadCase;
import info.rexs.model.jaxb.LoadSpectrum;
import info.rexs.model.jaxb.Model;
import info.rexs.model.transformer.RexsModelXmlTransformer;
import info.rexs.schema.constants.RexsUnitId;
import info.rexs.schema.constants.RexsVersion;
import info.rexs.schema.constants.standard.RexsStandardUnitIds;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;

public class RexsXmlFileWriter
extends AbstractRexsFileWriter {
    public RexsXmlFileWriter(Path pathToRexsOutputFile) {
        super(pathToRexsOutputFile);
    }

    public RexsXmlFileWriter(File rexsOutputFile) {
        super(rexsOutputFile);
    }

    public RexsXmlFileWriter(String rexsOutputFilePath) {
        super(rexsOutputFilePath);
    }

    @Override
    public void write(RexsModel model) throws RexsIoException {
        this.validateOutputFile();
        try {
            RexsModelXmlTransformer transformer = new RexsModelXmlTransformer();
            Model rawModel = transformer.transform(model);
            this.writeRawModel(rawModel, this.pathToRexsOutputFile);
        }
        catch (Exception ex) {
            throw new RexsIoException("error on writing rexs model to xml file", ex);
        }
    }

    public void writeRawModel(Model rawModel) throws RexsIoException {
        this.validateOutputFile();
        try {
            this.writeRawModel(rawModel, this.pathToRexsOutputFile);
        }
        catch (Exception ex) {
            throw new RexsIoException("error writing rexs model to xml file", ex);
        }
    }

    private void writeRawModel(Model rawModel, Path pathToFile) throws IOException, JAXBException {
        try (OutputStream output = Files.newOutputStream(pathToFile, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{Model.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this.convertDegreeUnits(rawModel), output);
        }
    }

    private Model convertDegreeUnits(Model model) {
        if (model.getComponents() == null || model.getComponents().getComponent().isEmpty()) {
            return model;
        }
        String versionName = model.getVersion();
        RexsVersion version = RexsVersion.findByModelVersion(versionName);
        if (version == null) {
            return model;
        }
        RexsUnitId searchUnit = version.isLessThan(RexsStandardVersions.V1_4) ? RexsStandardUnitIds.deg : RexsStandardUnitIds.degree;
        RexsUnitId replaceUnit = version.isLessThan(RexsStandardVersions.V1_4) ? RexsStandardUnitIds.degree : RexsStandardUnitIds.deg;
        ArrayList<Component> allComponents = new ArrayList<Component>();
        allComponents.addAll(model.getComponents().getComponent());
        for (LoadSpectrum spectrum : model.getLoadSpectrum()) {
            for (LoadCase loadCase : spectrum.getLoadCase()) {
                allComponents.addAll(loadCase.getComponent());
            }
            Accumulation accumulation = spectrum.getAccumulation();
            if (accumulation == null) continue;
            allComponents.addAll(accumulation.getComponent());
        }
        for (Component component : allComponents) {
            for (Attribute attribute : component.getAttribute()) {
                if (attribute.getUnit() == null || !attribute.getUnit().equals(searchUnit.getId())) continue;
                attribute.setUnit(replaceUnit.getId());
            }
        }
        return model;
    }
}

