/*
 * Decompiled with CFR 0.152.
 */
package info.rexs.upgrade.upgraders;

import info.rexs.model.RexsModel;
import info.rexs.schema.constants.standard.RexsStandardVersions;
import info.rexs.upgrade.RexsUpgradeException;
import info.rexs.upgrade.upgraders.ModelChangelogUpgrader;
import info.rexs.upgrade.upgraders.ModelUpgraderResult;
import info.rexs.upgrade.upgraders.UpgradeNotifications;
import info.rexs.upgrade.upgraders.changelog.ChangelogFile;
import info.rexs.upgrade.upgraders.changelog.ChangelogResolver;
import info.rexs.upgrade.upgraders.changelog.jaxb.RexsChangelog;

public class ModelUpgraderV14toV15 {
    private static final ChangelogFile CHANGELOG_FILE = ChangelogFile.V1_4_TO_V1_5;
    private RexsModel newModel;
    private final RexsModel oldModel;
    private final boolean strictMode;
    private RexsChangelog changelog;
    private UpgradeNotifications notifications = new UpgradeNotifications();

    public ModelUpgraderV14toV15(RexsModel model, boolean strictMode) {
        this.oldModel = model;
        this.newModel = new RexsModel(model);
        this.strictMode = strictMode;
        try {
            this.changelog = ChangelogResolver.getInstance().resolve(CHANGELOG_FILE);
        }
        catch (RexsUpgradeException ex) {
            System.err.println(ex);
        }
    }

    public ModelUpgraderResult doupgrade() throws RexsUpgradeException {
        ModelChangelogUpgrader changeLogUpgrader = new ModelChangelogUpgrader(this.newModel, this.changelog, this.strictMode);
        this.newModel = changeLogUpgrader.applyChangelog();
        this.notifications.addAll(changeLogUpgrader.getNotifications().getNotifications());
        this.newModel.setVersion(RexsStandardVersions.V1_5);
        this.newModel.setApplicationId("REXS API Upgrader");
        return new ModelUpgraderResult(this.newModel, this.notifications);
    }
}

